/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryEnvironmentUpdatedEvent;
import org.guvnor.structure.repositories.RepositoryService;

public class ManagedStatusUpdater {
    private RepositoryService repositoryService;
    private Event<RepositoryEnvironmentUpdatedEvent> repositoryUpdatedEvent;

    public ManagedStatusUpdater() {
    }

    @Inject
    public ManagedStatusUpdater(RepositoryService repositoryService, Event<RepositoryEnvironmentUpdatedEvent> repositoryUpdatedEvent) {
        this.repositoryService = repositoryService;
        this.repositoryUpdatedEvent = repositoryUpdatedEvent;
    }

    public Repository updateManagedStatus(Repository repository, boolean managed) {
        RepositoryEnvironmentConfigurations config = new RepositoryEnvironmentConfigurations();
        config.setManaged(managed);
        Repository updatedRepo = this.repositoryService.updateRepositoryConfiguration(repository, config);
        this.repositoryUpdatedEvent.fire((Object)new RepositoryEnvironmentUpdatedEvent(updatedRepo));
        return updatedRepo;
    }
}

