/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.asset.management.backend.service.AssetManagementServiceImpl;
import org.guvnor.asset.management.model.ConfigureRepositoryEvent;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class AssetManagementServiceImplTest {
    @Mock
    private Instance<ProjectService<?>> projectService;
    @Mock
    private IOService ioService;
    @Mock
    private POMService pomService;
    @Mock
    private RepositoryService repositoryService;
    private AssetManagementService assetManagementService;
    private final List<Object> receivedEvents = new ArrayList<Object>();
    private final List<Object> receivedBranchEvents = new ArrayList<Object>();
    private Event<NewBranchEvent> newBranchEvent = new EventSourceMock<NewBranchEvent>(){

        public void fire(NewBranchEvent event) {
            AssetManagementServiceImplTest.this.receivedBranchEvents.add(event);
        }
    };
    private Event<ConfigureRepositoryEvent> configureRepositoryEvent = new EventSourceMock<ConfigureRepositoryEvent>(){

        public void fire(ConfigureRepositoryEvent event) {
            AssetManagementServiceImplTest.this.receivedEvents.add(event);
        }
    };

    @Before
    public void setup() {
        this.receivedEvents.clear();
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileName()).thenReturn(Mockito.mock(Path.class));
        Mockito.when((Object)path.toUri()).thenReturn((Object)URI.create("dummy://test"));
        Mockito.when((Object)path.getFileSystem()).thenReturn(Mockito.mock(FileSystem.class));
        Mockito.when((Object)this.ioService.get((URI)Matchers.any(URI.class))).thenReturn((Object)path);
        this.assetManagementService = new AssetManagementServiceImpl(this.newBranchEvent, this.configureRepositoryEvent, this.pomService, this.ioService, this.repositoryService, this.projectService);
    }

    @Test
    public void testConfigureRepository() {
        this.assetManagementService.configureRepository("test-repo", "master", "dev", "release", "1.0.0");
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        Object event = this.receivedEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof ConfigureRepositoryEvent));
        ConfigureRepositoryEvent eventReceived = (ConfigureRepositoryEvent)event;
        Map parameters = eventReceived.getParams();
        Assert.assertNotNull((Object)parameters);
        Assert.assertEquals((long)5L, (long)parameters.size());
        Assert.assertTrue((boolean)parameters.containsKey("RepositoryName"));
        Assert.assertTrue((boolean)parameters.containsKey("SourceBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("DevBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("RelBranchName"));
        Assert.assertTrue((boolean)parameters.containsKey("Version"));
        Assert.assertEquals((Object)"test-repo", parameters.get("RepositoryName"));
        Assert.assertEquals((Object)"master", parameters.get("SourceBranchName"));
        Assert.assertEquals((Object)"dev", parameters.get("DevBranchName"));
        Assert.assertEquals((Object)"release", parameters.get("RelBranchName"));
        Assert.assertEquals((Object)"1.0.0", parameters.get("Version"));
        Assert.assertEquals((long)2L, (long)this.receivedBranchEvents.size());
        event = this.receivedBranchEvents.get(0);
        Assert.assertTrue((boolean)(event instanceof NewBranchEvent));
        Assert.assertEquals((Object)"test-repo", (Object)((NewBranchEvent)event).getRepositoryAlias());
        Assert.assertEquals((Object)"dev-1.0.0", (Object)((NewBranchEvent)event).getBranchName());
        event = this.receivedBranchEvents.get(1);
        Assert.assertTrue((boolean)(event instanceof NewBranchEvent));
        Assert.assertEquals((Object)"test-repo", (Object)((NewBranchEvent)event).getRepositoryAlias());
        Assert.assertEquals((Object)"release-1.0.0", (Object)((NewBranchEvent)event).getBranchName());
    }
}

