/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.backend.social;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.ext.uberfire.social.activities.model.SocialActivitiesEvent;
import org.ext.uberfire.social.activities.model.SocialEventType;
import org.ext.uberfire.social.activities.repository.SocialUserRepository;
import org.ext.uberfire.social.activities.service.SocialAdapter;
import org.ext.uberfire.social.activities.service.SocialCommandTypeFilter;
import org.guvnor.asset.management.backend.social.i18n.Constants;
import org.guvnor.asset.management.social.AssetManagementEventTypes;
import org.guvnor.structure.repositories.NewBranchEvent;

@ApplicationScoped
public class NewBranchEventAdapter
implements SocialAdapter<NewBranchEvent> {
    @Inject
    private SocialUserRepository socialUserRepository;
    @Inject
    private Constants constants;

    public Class<NewBranchEvent> eventToIntercept() {
        return NewBranchEvent.class;
    }

    public SocialEventType socialEventType() {
        return AssetManagementEventTypes.BRANCH_CREATED;
    }

    public boolean shouldInterceptThisEvent(Object event) {
        return event.getClass().getSimpleName().equals(this.eventToIntercept().getSimpleName());
    }

    public SocialActivitiesEvent toSocial(Object object) {
        NewBranchEvent event = (NewBranchEvent)object;
        return new SocialActivitiesEvent(this.socialUserRepository.systemUser(), AssetManagementEventTypes.BRANCH_CREATED.name(), new Date(event.getTimestamp())).withLink(event.getRepositoryAlias(), event.getBranchPath().toURI()).withAdicionalInfo(new String[]{this.getAdditionalInfo(event.getBranchName(), event.getRepositoryAlias())});
    }

    public List<SocialCommandTypeFilter> getTimelineFilters() {
        return new ArrayList<SocialCommandTypeFilter>();
    }

    public List<String> getTimelineFiltersNames() {
        return new ArrayList<String>();
    }

    private String getAdditionalInfo(String branch, String repository) {
        return this.constants.configure_repository_branch_created(branch, repository);
    }
}

