/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.project.structure.widgets;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ButtonCell;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModuleRow;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModulesView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;

public class ProjectModulesViewImpl
extends Composite
implements ProjectModulesView {
    private static ProjectModulesEditorViewImplUIBinder uiBinder = (ProjectModulesEditorViewImplUIBinder)GWT.create(ProjectModulesEditorViewImplUIBinder.class);
    @UiField(provided=true)
    final SimpleTable<ProjectModuleRow> modulesTable = new SimpleTable();
    @UiField
    Button addModuleButton;
    @UiField
    Label modulesLabel;
    private Column<ProjectModuleRow, ?> modulesColumn;
    private ProjectModulesView.Presenter presenter;
    private boolean actionsEnabled = true;

    public ProjectModulesViewImpl() {
        this.addModuleColumn();
        this.addEditModuleColumn();
        this.addDeleteModuleColumn();
        this.modulesTable.setToolBarVisible(false);
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @Override
    public void setPresenter(ProjectModulesView.Presenter presenter) {
        this.presenter = presenter;
        presenter.addDataDisplay((HasData<ProjectModuleRow>)this.modulesTable);
    }

    @Override
    public void setMode(ProjectModulesView.ViewMode mode) {
        if (mode == ProjectModulesView.ViewMode.PROJECTS_VIEW) {
            this.addModuleButton.setText(Constants.INSTANCE.NewProject());
            this.modulesLabel.setText(Constants.INSTANCE.Projects());
            if (this.modulesColumn != null) {
                this.modulesColumn.setDataStoreName(Constants.INSTANCE.Project());
            }
        } else {
            this.addModuleButton.setText(Constants.INSTANCE.AddModule());
            this.modulesLabel.setText(Constants.INSTANCE.Modules());
            if (this.modulesColumn != null) {
                this.modulesColumn.setDataStoreName(Constants.INSTANCE.Module());
            }
        }
    }

    @Override
    public void enableActions(boolean value) {
        this.addModuleButton.setEnabled(value);
        this.actionsEnabled = value;
    }

    private void addModuleColumn() {
        this.modulesColumn = new Column<ProjectModuleRow, String>((Cell)new TextCell()){

            public String getValue(ProjectModuleRow row) {
                return row.getName();
            }
        };
        this.modulesTable.addColumn(this.modulesColumn, Constants.INSTANCE.Module());
        this.modulesTable.setColumnWidth(this.modulesColumn, 70.0, Style.Unit.PCT);
    }

    private void addDeleteModuleColumn() {
        ButtonCell deleteModuleButton = new ButtonCell(ButtonSize.SMALL);
        deleteModuleButton.setType(ButtonType.DANGER);
        deleteModuleButton.setIcon(IconType.MINUS_SIGN);
        Column<ProjectModuleRow, String> deleteModuleColumn = new Column<ProjectModuleRow, String>((Cell)deleteModuleButton){

            public String getValue(ProjectModuleRow moduleRow) {
                return Constants.INSTANCE.DeleteModule();
            }
        };
        deleteModuleColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<ProjectModuleRow, String>(){

            public void update(int index, ProjectModuleRow moduleRow, String value) {
                if (ProjectModulesViewImpl.this.presenter != null && ProjectModulesViewImpl.this.actionsEnabled) {
                    ProjectModulesViewImpl.this.presenter.onDeleteModule(moduleRow);
                }
            }
        });
        this.modulesTable.addColumn((Column)deleteModuleColumn, "");
        this.modulesTable.setColumnWidth((Column)deleteModuleColumn, 15.0, Style.Unit.PCT);
    }

    private void addEditModuleColumn() {
        ButtonCell editModuleButton = new ButtonCell(ButtonSize.SMALL);
        editModuleButton.setType(ButtonType.PRIMARY);
        editModuleButton.setIcon(IconType.EDIT);
        Column<ProjectModuleRow, String> editModuleColumn = new Column<ProjectModuleRow, String>((Cell)editModuleButton){

            public String getValue(ProjectModuleRow moduleRow) {
                return Constants.INSTANCE.EditModule();
            }
        };
        editModuleColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<ProjectModuleRow, String>(){

            public void update(int index, ProjectModuleRow moduleRow, String value) {
                if (ProjectModulesViewImpl.this.presenter != null && ProjectModulesViewImpl.this.actionsEnabled) {
                    ProjectModulesViewImpl.this.presenter.onEditModule(moduleRow);
                }
            }
        });
        this.modulesTable.addColumn((Column)editModuleColumn, "");
        this.modulesTable.setColumnWidth((Column)editModuleColumn, 15.0, Style.Unit.PCT);
    }

    @UiHandler(value={"addModuleButton"})
    void onAddModuleButtonClick(ClickEvent e) {
        this.presenter.onAddModule();
    }

    static interface ProjectModulesEditorViewImplUIBinder
    extends UiBinder<Widget, ProjectModulesViewImpl> {
    }
}

