/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure.configure;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.guvnor.asset.management.client.i18n.Constants;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class ConfigureScreenPopupViewImpl
extends BaseModal {
    private ConfigureScreenPopupWidgetBinder uiBinder = (ConfigureScreenPopupWidgetBinder)GWT.create(ConfigureScreenPopupWidgetBinder.class);
    @Inject
    private User identity;
    @UiField
    ControlGroup repositoryTextGroup;
    @UiField
    TextBox repositoryText;
    @UiField
    HelpInline repositoryTextHelpInline;
    @UiField
    ControlGroup sourceBranchTextGroup;
    @UiField
    TextBox sourceBranchText;
    @UiField
    HelpInline sourceBranchTextHelpInline;
    @UiField
    ControlGroup devBranchTextGroup;
    @UiField
    TextBox devBranchText;
    @UiField
    HelpInline devBranchTextHelpInline;
    @UiField
    ControlGroup releaseBranchTextGroup;
    @UiField
    TextBox releaseBranchText;
    @UiField
    HelpInline releaseBranchTextHelpInline;
    @UiField
    HelpInline versionTextHelpInline;
    @UiField
    ControlGroup versionTextGroup;
    @UiField
    TextBox versionText;
    private Command callbackCommand;
    private final Command okCommand = new Command(){

        public void execute() {
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.devBranchText.getText())) {
                ConfigureScreenPopupViewImpl.this.devBranchTextGroup.setType(ControlGroupType.ERROR);
                ConfigureScreenPopupViewImpl.this.devBranchTextHelpInline.setText(Constants.INSTANCE.FieldMandatory0("Dev Branch"));
                return;
            }
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.releaseBranchText.getText())) {
                ConfigureScreenPopupViewImpl.this.releaseBranchTextGroup.setType(ControlGroupType.ERROR);
                ConfigureScreenPopupViewImpl.this.releaseBranchTextHelpInline.setText(Constants.INSTANCE.FieldMandatory0("Release Branch"));
                return;
            }
            if (this.isEmpty(ConfigureScreenPopupViewImpl.this.versionText.getText())) {
                ConfigureScreenPopupViewImpl.this.versionTextGroup.setType(ControlGroupType.ERROR);
                ConfigureScreenPopupViewImpl.this.versionTextHelpInline.setText(Constants.INSTANCE.FieldMandatory0("Version"));
                return;
            }
            if (ConfigureScreenPopupViewImpl.this.callbackCommand != null) {
                ConfigureScreenPopupViewImpl.this.callbackCommand.execute();
            }
            ConfigureScreenPopupViewImpl.this.hide();
        }

        private boolean isEmpty(String value) {
            return value == null || value.isEmpty();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            ConfigureScreenPopupViewImpl.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public ConfigureScreenPopupViewImpl() {
        this.setTitle(Constants.INSTANCE.Configure_Repository());
        this.setBackdrop(BackdropType.STATIC);
        this.setKeyboard(true);
        this.setAnimation(true);
        this.setDynamicSafe(true);
        this.add((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
    }

    public void configure(String repositoryAlias, String branch, String repositoryVersion, Command command) {
        this.callbackCommand = command;
        this.devBranchText.setText("dev");
        this.devBranchTextHelpInline.setText("The branch will be called (dev)-" + repositoryVersion);
        this.releaseBranchText.setText("release");
        this.releaseBranchTextHelpInline.setText("The branch will be called (release)-" + repositoryVersion);
        this.sourceBranchText.setText(branch);
        this.repositoryText.setText(repositoryAlias);
        this.sourceBranchText.setReadOnly(true);
        this.repositoryText.setReadOnly(true);
        this.versionTextHelpInline.setText("The current repository version is: " + repositoryVersion);
        this.versionText.setText(repositoryVersion);
    }

    public String getDevBranch() {
        return this.devBranchText.getText();
    }

    public String getReleaseBranch() {
        return this.releaseBranchText.getText();
    }

    public String getVersion() {
        return this.versionText.getText();
    }

    static interface ConfigureScreenPopupWidgetBinder
    extends UiBinder<Widget, ConfigureScreenPopupViewImpl> {
    }
}

