/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Event;
import org.guvnor.asset.management.client.editors.project.structure.widgets.ProjectModulesView;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructurePresenter;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.model.RepositoryStructureModel;
import org.guvnor.asset.management.service.AssetManagementService;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.client.repositories.ConflictingRepositoriesPopup;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectWizard;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.guvnor.common.services.project.service.GAVAlreadyExistsException;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.security.impl.KieWorkbenchACLImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryStructurePresenterTest {
    @Mock
    private RepositoryStructureView view;
    @Mock
    private RepositoryStructureDataView dataView;
    @Mock
    private ProjectModulesView modulesView;
    @Mock
    private POMService pomService;
    @Mock
    private RepositoryStructureService repositoryStructureService;
    @Mock
    private AssetManagementService assetManagementService;
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock<ChangeTitleWidgetEvent>(){

        public void fire(ChangeTitleWidgetEvent event) {
        }
    };
    private Event<ProjectContextChangeEvent> contextChangeEvent = new EventSourceMock<ProjectContextChangeEvent>(){

        public void fire(ProjectContextChangeEvent event) {
        }
    };
    @Mock
    private ErrorPopupPresenter errorPopup;
    @Mock
    private ConflictingRepositoriesPopup conflictingRepositoriesPopup;
    @Mock
    private KieWorkbenchACLImpl kieACL;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ProjectContext workbenchContext;
    @Mock
    private ProjectWizard wizard;
    @Mock
    private OrganizationalUnit organizationalUnit;
    @Mock
    private Repository repository;
    @Mock
    private Project project;
    private RepositoryStructurePresenter presenter;

    @Before
    public void setup() {
        CallerMock pomServiceCaller = new CallerMock((Object)this.pomService);
        CallerMock repositoryStructureServiceCaller = new CallerMock((Object)this.repositoryStructureService);
        CallerMock assetManagementServiceCaller = new CallerMock((Object)this.assetManagementService);
        Mockito.when((Object)this.view.getDataView()).thenReturn((Object)this.dataView);
        Mockito.when((Object)this.view.getModulesView()).thenReturn((Object)this.modulesView);
        this.presenter = new RepositoryStructurePresenter(this.view, (Caller)pomServiceCaller, (Caller)repositoryStructureServiceCaller, (Caller)assetManagementServiceCaller, this.changeTitleWidgetEvent, this.contextChangeEvent, this.errorPopup, this.conflictingRepositoriesPopup, this.kieACL, this.placeManager, this.workbenchContext, this.wizard){

            ObservablePath createObservablePath(Path path) {
                return new ObservablePathImpl().wrap(path);
            }

            void destroyObservablePath(ObservablePath path) {
            }
        };
    }

    @Test
    public void testOnStartupNoRepositoryNoProject() throws Exception {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModulesViewVisible(Mockito.eq((boolean)false));
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).enableActions(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnStartupWithRepositoryNoProject() throws Exception {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModulesViewVisible(Mockito.eq((boolean)false));
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).enableActions(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnStartupWithRepositoryWithProjectNoModel() throws Exception {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        Object model = null;
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn(model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModulesViewVisible(Mockito.eq((boolean)false));
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).enableActions(Mockito.eq((boolean)true));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Constants.INSTANCE.Loading());
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void testOnStartupWithRepositoryWithProjectWithModel_SingleModule() throws Exception {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        model.setManaged(Boolean.valueOf(true));
        model.setOrphanProjects((List)new ArrayList<Project>(){
            {
                this.add(RepositoryStructurePresenterTest.this.project);
            }
        });
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).enableActions(Mockito.eq((boolean)true));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Constants.INSTANCE.Loading());
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).setMode((RepositoryStructureDataView.ViewMode)Mockito.eq((Object)RepositoryStructureDataView.ViewMode.EDIT_SINGLE_MODULE_PROJECT));
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).setMode((ProjectModulesView.ViewMode)Mockito.eq((Object)ProjectModulesView.ViewMode.PROJECTS_VIEW));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModel((RepositoryStructureModel)Mockito.eq((Object)model));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModulesViewVisible(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnStartupWithRepositoryWithProjectWithModel_MultiModule() throws Exception {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        POM pom = new POM(new GAV("groupId", "artifactId", "version"));
        model.setManaged(Boolean.valueOf(true));
        model.setPOM(pom);
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).clear();
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).enableActions(Mockito.eq((boolean)true));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Constants.INSTANCE.Loading());
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.dataView, (VerificationMode)Mockito.times((int)1))).setMode((RepositoryStructureDataView.ViewMode)Mockito.eq((Object)RepositoryStructureDataView.ViewMode.EDIT_MULTI_MODULE_PROJECT));
        ((ProjectModulesView)Mockito.verify((Object)this.modulesView, (VerificationMode)Mockito.times((int)1))).setMode((ProjectModulesView.ViewMode)Mockito.eq((Object)ProjectModulesView.ViewMode.MODULES_VIEW));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModel((RepositoryStructureModel)Mockito.eq((Object)model));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModulesViewVisible(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnInitRepositoryStructureNonClashingGAV() {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        POM pom = new POM(new GAV("groupId", "artifactId", "version"));
        model.setManaged(Boolean.valueOf(true));
        model.setPOM(pom);
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        this.presenter.onInitRepositoryStructure();
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.Loading()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.CreatingRepositoryStructure()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).hideBusyIndicator();
    }

    @Test
    public void testOnInitRepositoryStructureClashingGAV() {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        POM pom = new POM(new GAV("groupId", "artifactId", "version"));
        model.setManaged(Boolean.valueOf(true));
        model.setPOM(pom);
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((RepositoryStructureService)Mockito.doThrow((Throwable)gae).when((Object)this.repositoryStructureService)).initRepositoryStructure((GAV)Mockito.any(GAV.class), (Repository)Mockito.eq((Object)this.repository), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        this.presenter.onInitRepositoryStructure();
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).load(this.repository);
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)commandArgumentCaptor.capture());
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.Loading()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.CreatingRepositoryStructure()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void testOnInitRepositoryStructureClashingGAVForced() {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        POM pom = new POM(new GAV("groupId", "artifactId", "version"));
        model.setManaged(Boolean.valueOf(true));
        model.setPOM(pom);
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        GAVAlreadyExistsException gae = new GAVAlreadyExistsException(pom.getGav(), (Set)new HashSet<MavenRepositoryMetadata>(){
            {
                this.add(new MavenRepositoryMetadata("local-id", "local-url", MavenRepositorySource.LOCAL));
            }
        });
        ((RepositoryStructureService)Mockito.doThrow((Throwable)gae).when((Object)this.repositoryStructureService)).initRepositoryStructure((GAV)Mockito.any(GAV.class), (Repository)Mockito.eq((Object)this.repository), (DeploymentMode)Mockito.eq((Object)DeploymentMode.VALIDATED));
        this.presenter.onInitRepositoryStructure();
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)1))).load(this.repository);
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).setContent((GAV)Mockito.eq((Object)pom.getGav()), (Set)Mockito.any(Set.class), (Command)commandArgumentCaptor.capture());
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).show();
        Assert.assertNotNull((Object)commandArgumentCaptor.getValue());
        ((Command)commandArgumentCaptor.getValue()).execute();
        ((ConflictingRepositoriesPopup)Mockito.verify((Object)this.conflictingRepositoriesPopup, (VerificationMode)Mockito.times((int)1))).hide();
        ((RepositoryStructureService)Mockito.verify((Object)this.repositoryStructureService, (VerificationMode)Mockito.times((int)2))).load(this.repository);
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.Loading()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).showBusyIndicator((String)Mockito.eq((Object)Constants.INSTANCE.CreatingRepositoryStructure()));
        ((RepositoryStructureView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).hideBusyIndicator();
    }

    @Test
    public void testOnAddModuleSingleModule() {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        model.setManaged(Boolean.valueOf(true));
        model.setOrphanProjects((List)new ArrayList<Project>(){
            {
                this.add(RepositoryStructurePresenterTest.this.project);
            }
        });
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        this.presenter.onAddModule();
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)1))).initialise((POM)pomArgumentCaptor.capture());
        ((ProjectWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)1))).start((Callback)Matchers.any(), Mockito.eq((boolean)false));
        POM pom = (POM)pomArgumentCaptor.getValue();
        Assert.assertNotNull((Object)pom);
        Assert.assertNotNull((Object)pom.getGav());
        Assert.assertNull((Object)pom.getGav().getGroupId());
        Assert.assertNull((Object)pom.getGav().getArtifactId());
        Assert.assertNull((Object)pom.getGav().getVersion());
    }

    @Test
    public void testOnAddModuleMultiModule() {
        Mockito.when((Object)this.workbenchContext.getActiveOrganizationalUnit()).thenReturn((Object)this.organizationalUnit);
        Mockito.when((Object)this.workbenchContext.getActiveRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.workbenchContext.getActiveProject()).thenReturn((Object)this.project);
        RepositoryStructureModel model = new RepositoryStructureModel();
        POM pom = new POM(new GAV("groupId", "artifactId", "version"));
        model.setManaged(Boolean.valueOf(true));
        model.setPOM(pom);
        Mockito.when((Object)this.repositoryStructureService.load(this.repository)).thenReturn((Object)model);
        Mockito.when((Object)this.dataView.getGroupId()).thenReturn((Object)"groupId");
        Mockito.when((Object)this.dataView.getArtifactId()).thenReturn((Object)"artifactId");
        Mockito.when((Object)this.dataView.getVersion()).thenReturn((Object)"version");
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.onStartup(placeRequest);
        this.presenter.onAddModule();
        ArgumentCaptor pomArgumentCaptor = ArgumentCaptor.forClass(POM.class);
        ((ProjectWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)1))).initialise((POM)pomArgumentCaptor.capture());
        ((ProjectWizard)Mockito.verify((Object)this.wizard, (VerificationMode)Mockito.times((int)1))).start((Callback)Matchers.any(), Mockito.eq((boolean)false));
        POM wizardPom = (POM)pomArgumentCaptor.getValue();
        Assert.assertNotNull((Object)wizardPom);
        GAV moduleGAV = wizardPom.getGav();
        Assert.assertNotNull((Object)moduleGAV);
        Assert.assertEquals((Object)"groupId", (Object)moduleGAV.getGroupId());
        Assert.assertNull((Object)moduleGAV.getArtifactId());
        Assert.assertEquals((Object)"version", (Object)moduleGAV.getVersion());
        GAV parentGav = wizardPom.getParent();
        Assert.assertNotNull((Object)parentGav);
        Assert.assertEquals((Object)"groupId", (Object)parentGav.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)parentGav.getArtifactId());
        Assert.assertEquals((Object)"version", (Object)parentGav.getVersion());
    }
}

