/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureContext;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.repositories.Repository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryStructureContextTest {
    private RepositoryStructureContext context;
    @Mock
    Repository currentRepository;
    @Mock
    Project currentProject;

    @Before
    public void setUp() throws Exception {
        this.context = new RepositoryStructureContext();
    }

    @Test
    public void testEmptySetupProjectChanged() throws Exception {
        Assert.assertTrue((boolean)this.context.activeProjectChanged(new Project()));
    }

    @Test
    public void testEmptySetupRepositoryChanged() throws Exception {
        Assert.assertTrue((boolean)this.context.repositoryOrBranchChanged((Repository)Mockito.mock(Repository.class), "master"));
    }

    @Test
    public void testProjectChanged() throws Exception {
        this.context.reset(this.currentRepository, "master", this.currentProject);
        Assert.assertTrue((boolean)this.context.activeProjectChanged(new Project()));
    }

    @Test
    public void testRepositoryChanged() throws Exception {
        this.context.reset(this.currentRepository, "master", this.currentProject);
        Assert.assertTrue((boolean)this.context.repositoryOrBranchChanged((Repository)Mockito.mock(Repository.class), "master"));
    }

    @Test
    public void testBranchChanged() throws Exception {
        this.context.reset(this.currentRepository, "master", this.currentProject);
        Assert.assertTrue((boolean)this.context.repositoryOrBranchChanged(this.currentRepository, "dev"));
    }
}

