/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.structure;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.repository.structure.ActionHistory;
import org.guvnor.asset.management.client.editors.repository.structure.RepositoryStructureView;
import org.guvnor.asset.management.client.i18n.Constants;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectWizard;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;

@Dependent
public class RepositoryManagedStatusUpdater {
    private final ProjectWizard wizard;
    private final Caller<RepositoryStructureService> repositoryStructureService;
    private HasBusyIndicator view;
    private ActionHistory history;
    private RepositoryStructureView.Presenter presenter;

    @Inject
    public RepositoryManagedStatusUpdater(Caller<RepositoryStructureService> repositoryStructureService, ProjectWizard wizard) {
        this.repositoryStructureService = repositoryStructureService;
        this.wizard = wizard;
    }

    public void bind(HasBusyIndicator view, ActionHistory history, RepositoryStructureView.Presenter initRepository) {
        this.view = view;
        this.history = history;
        this.presenter = initRepository;
    }

    public void updateNonManaged(Repository repository, String branch) {
        this.setManagedStatus(repository, branch, false);
    }

    public void initSingleProject(final Repository repository, final String branch) {
        this.wizard.initialise(new POM());
        this.wizard.start((Callback)new Callback<Project>(){

            public void callback(Project result) {
                RepositoryManagedStatusUpdater.this.history.setLastAddedModule(result);
                if (result != null) {
                    RepositoryManagedStatusUpdater.this.setManagedStatus(repository, branch, true);
                }
            }
        }, false);
    }

    private void setManagedStatus(Repository repository, final String branch, boolean managed) {
        this.view.showBusyIndicator(Constants.INSTANCE.CreatingRepositoryStructure());
        ((RepositoryStructureService)this.repositoryStructureService.call((RemoteCallback)new RemoteCallback<Repository>(){

            public void callback(Repository repository) {
                RepositoryManagedStatusUpdater.this.presenter.loadModel(repository, branch);
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(this.view))).updateManagedStatus(repository, managed);
    }
}

