/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.WizardTestUtils;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryStructurePageView;
import org.guvnor.asset.management.service.RepositoryStructureService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryStructurePageTest {
    private static final String VALID_VALUE = "Valid";
    private static final String INVALID_VALUE = "Invalid";
    @GwtMock
    RepositoryStructurePageView view;
    RepositoryStructureService repositoryStructureService = (RepositoryStructureService)Mockito.mock(RepositoryStructureService.class);

    @Test
    public void testPageLoad() {
        RepositoryStructurePage structurePage = new RepositoryStructurePage(this.view, (Caller)new CallerMock((Object)this.repositoryStructureService));
    }

    @Test
    public void testValidProjectNameChange() {
        this.testProjectNameChange(true);
    }

    @Test
    public void testInvalidProjectNameChange() {
        this.testProjectNameChange(false);
    }

    private void testProjectNameChange(boolean testValidChange) {
        RepositoryStructurePageExtended structurePage = new RepositoryStructurePageExtended(this.view, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        structurePage.setModel(model);
        if (testValidChange) {
            Mockito.when((Object)this.view.getProjectName()).thenReturn((Object)VALID_VALUE);
        } else {
            Mockito.when((Object)this.view.getProjectName()).thenReturn((Object)INVALID_VALUE);
        }
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(VALID_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(INVALID_VALUE)).thenReturn((Object)false);
        structurePage.onProjectNameChange();
        ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getProjectName();
        if (testValidChange) {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearProjectNameErrorMessage();
            Assert.assertEquals((Object)VALID_VALUE, (Object)model.getProjectName());
        } else {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setProjectNameErrorMessage(Mockito.anyString());
            Assert.assertEquals((Object)INVALID_VALUE, (Object)model.getProjectName());
        }
        WizardTestUtils.assertPageComplete(false, (WizardPage)structurePage);
    }

    @Test
    public void testValidGroupIdChange() {
        this.testGroupIdChange(true);
    }

    @Test
    public void testInvalidGroupIdChange() {
        this.testGroupIdChange(false);
    }

    private void testGroupIdChange(boolean testValidChange) {
        RepositoryStructurePageExtended structurePage = new RepositoryStructurePageExtended(this.view, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        structurePage.setModel(model);
        if (testValidChange) {
            Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)VALID_VALUE);
        } else {
            Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)INVALID_VALUE);
        }
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(INVALID_VALUE)).thenReturn((Object)false);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(VALID_VALUE)).thenReturn((Object)true);
        structurePage.onGroupIdChange();
        ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getGroupId();
        if (testValidChange) {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearGroupIdErrorMessage();
            Assert.assertEquals((Object)VALID_VALUE, (Object)model.getGroupId());
        } else {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setGroupIdErrorMessage(Mockito.anyString());
            Assert.assertEquals((Object)INVALID_VALUE, (Object)model.getGroupId());
        }
        WizardTestUtils.assertPageComplete(false, (WizardPage)structurePage);
    }

    @Test
    public void testValidArtifactIdChange() {
        this.testArtifactIdChange(true);
    }

    @Test
    public void testInvalidArtifactIdChange() {
        this.testArtifactIdChange(false);
    }

    private void testArtifactIdChange(boolean testValidChange) {
        RepositoryStructurePageExtended structurePage = new RepositoryStructurePageExtended(this.view, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        structurePage.setModel(model);
        if (testValidChange) {
            Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)VALID_VALUE);
        } else {
            Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)INVALID_VALUE);
        }
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(VALID_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(INVALID_VALUE)).thenReturn((Object)false);
        structurePage.onArtifactIdChange();
        ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getArtifactId();
        if (testValidChange) {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearArtifactIdErrorMessage();
            Assert.assertEquals((Object)VALID_VALUE, (Object)model.getArtifactId());
        } else {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setArtifactIdErrorMessage(Mockito.anyString());
            Assert.assertEquals((Object)INVALID_VALUE, (Object)model.getArtifactId());
        }
        WizardTestUtils.assertPageComplete(false, (WizardPage)structurePage);
    }

    @Test
    public void testValidVersionChange() {
        this.testVersionChange(true);
    }

    @Test
    public void testInvalidVersionChange() {
        this.testVersionChange(false);
    }

    private void testVersionChange(boolean testValidChange) {
        RepositoryStructurePageExtended structurePage = new RepositoryStructurePageExtended(this.view, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        structurePage.setModel(model);
        if (testValidChange) {
            Mockito.when((Object)this.view.getVersion()).thenReturn((Object)VALID_VALUE);
        } else {
            Mockito.when((Object)this.view.getVersion()).thenReturn((Object)INVALID_VALUE);
        }
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(VALID_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(INVALID_VALUE)).thenReturn((Object)false);
        structurePage.onVersionChange();
        ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getVersion();
        if (testValidChange) {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearVersionErrorMessage();
            Assert.assertEquals((Object)VALID_VALUE, (Object)model.getVersion());
        } else {
            ((RepositoryStructurePageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setVersionErrorMessage(Mockito.anyString());
            Assert.assertEquals((Object)INVALID_VALUE, (Object)model.getVersion());
        }
        WizardTestUtils.assertPageComplete(false, (WizardPage)structurePage);
    }

    @Test
    public void testPageCompleted() {
        String projectName = "ProjectName";
        String groupId = "GroupId";
        String artifactId = "ArtifactId";
        String version = "Version";
        RepositoryStructurePageExtended structurePage = new RepositoryStructurePageExtended(this.view, (Caller<RepositoryStructureService>)new CallerMock((Object)this.repositoryStructureService), new WizardTestUtils.WizardPageStatusChangeEventMock());
        CreateRepositoryWizardModel model = new CreateRepositoryWizardModel();
        structurePage.setModel(model);
        Mockito.when((Object)this.view.getProjectName()).thenReturn((Object)projectName);
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)groupId);
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)artifactId);
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)version);
        Mockito.when((Object)this.repositoryStructureService.isValidProjectName(projectName)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidGroupId(groupId)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidArtifactId(artifactId)).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryStructureService.isValidVersion(version)).thenReturn((Object)true);
        structurePage.prepareView();
        structurePage.setStructurePageWasVisited(true);
        structurePage.onProjectNameChange();
        structurePage.onGroupIdChange();
        structurePage.onArtifactIdChange();
        structurePage.onVersionChange();
        WizardTestUtils.assertPageComplete(true, (WizardPage)structurePage);
        Assert.assertEquals((Object)projectName, (Object)model.getProjectName());
        Assert.assertEquals((Object)groupId, (Object)model.getGroupId());
        Assert.assertEquals((Object)artifactId, (Object)model.getArtifactId());
        Assert.assertEquals((Object)version, (Object)model.getVersion());
    }

    public static class RepositoryStructurePageExtended
    extends RepositoryStructurePage {
        public RepositoryStructurePageExtended(RepositoryStructurePageView view, Caller<RepositoryStructureService> repositoryStructureService, WizardTestUtils.WizardPageStatusChangeEventMock event) {
            super(view, repositoryStructureService);
            this.wizardPageStatusChangeEvent = event;
        }
    }
}

