/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.project.structure.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.common.services.project.model.GAV;

@Dependent
public class RepositoryStructureDataPresenter
implements IsWidget {
    private final RepositoryStructureDataView view;

    @Inject
    public RepositoryStructureDataPresenter(RepositoryStructureDataView view) {
        this.view = view;
        view.clear();
        this.setMode(RepositoryStructureDataView.ViewMode.CREATE_STRUCTURE);
    }

    public void setMode(RepositoryStructureDataView.ViewMode mode) {
        if (mode == RepositoryStructureDataView.ViewMode.CREATE_STRUCTURE) {
            this.view.setCreateStructureText();
        } else if (mode == RepositoryStructureDataView.ViewMode.EDIT_SINGLE_MODULE_PROJECT) {
            this.view.setEditSingleModuleProjectText();
            this.view.setEditModuleVisibility(true);
        } else if (mode == RepositoryStructureDataView.ViewMode.EDIT_MULTI_MODULE_PROJECT) {
            this.view.setEditMultiModuleProjectText();
            this.view.setEditModuleVisibility(true);
        } else if (mode == RepositoryStructureDataView.ViewMode.EDIT_UNMANAGED_REPOSITORY) {
            this.view.setEditUnmanagedRepositoryText();
            this.view.setEditModuleVisibility(false);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void clear() {
        this.view.clear();
    }

    public GAV getGav() {
        return new GAV(this.view.getGroupId(), this.view.getArtifactId(), this.view.getVersion());
    }

    public void setGav(GAV gav) {
        this.view.setGroupId(gav.getGroupId());
        this.view.setArtifactId(gav.getArtifactId());
        this.view.setVersion(gav.getVersion());
    }
}

