/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.repository.wizard.pages;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.guvnor.asset.management.client.editors.repository.wizard.CreateRepositoryWizardModel;
import org.guvnor.asset.management.client.editors.repository.wizard.WizardTestUtils;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPage;
import org.guvnor.asset.management.client.editors.repository.wizard.pages.RepositoryInfoPageView;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.OrganizationalUnitServiceCallerMock;
import org.guvnor.structure.organizationalunit.impl.OrganizationalUnitImpl;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceCallerMock;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryInfoPageTest {
    @GwtMock
    RepositoryInfoPageView view;
    OrganizationalUnitService organizationalUnitService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    List<OrganizationalUnit> organizationalUnits = RepositoryInfoPageTest.buildOrganiztionalUnits();
    List<Pair<String, String>> organizationalUnitsInfo = RepositoryInfoPageTest.buildOrganiztionalUnitsInfo(this.organizationalUnits);
    RepositoryInfoPage infoPage;
    CreateRepositoryWizardModel model;
    WizardTestUtils.WizardPageStatusChangeHandler statusChangeHandler = (WizardTestUtils.WizardPageStatusChangeHandler)Mockito.mock(WizardTestUtils.WizardPageStatusChangeHandler.class);

    @Before
    public void initPage() {
        WizardTestUtils.WizardPageStatusChangeEventMock event = new WizardTestUtils.WizardPageStatusChangeEventMock();
        this.infoPage = new RepositoryInfoPageExtended(this.view, (Caller<OrganizationalUnitService>)new OrganizationalUnitServiceCallerMock(this.organizationalUnitService), (Caller<RepositoryService>)new RepositoryServiceCallerMock(this.repositoryService), true, event);
        event.addEventHandler(this.statusChangeHandler);
        this.model = new CreateRepositoryWizardModel();
        this.infoPage.setModel(this.model);
    }

    @Test
    public void testPageLoad() {
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        this.infoPage.prepareView();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.infoPage);
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view)).initOrganizationalUnits((List)Mockito.eq(this.organizationalUnitsInfo));
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.never())).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testNoSelectedOrganizationalUnit() {
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        Mockito.when((Object)this.view.getOrganizationalUnitName()).thenReturn((Object)"NOT_SELECTED");
        this.infoPage.prepareView();
        this.infoPage.onOUChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getOrganizationalUnitName();
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.never())).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        Assert.assertEquals(null, (Object)this.model.getOrganizationalUnit());
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testOrganizationalUnitChange() {
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        Mockito.when((Object)this.view.getOrganizationalUnitName()).thenReturn((Object)"OrganizationalUnit1");
        this.infoPage.prepareView();
        this.infoPage.onOUChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getOrganizationalUnitName();
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.times((int)1))).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testValidRepositoryNameChange() {
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("InvalidRepo")).thenReturn((Object)false);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"ValidRepo");
        this.infoPage.onNameChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getName();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearNameErrorMessage();
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.times((int)1))).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        Assert.assertEquals((Object)"ValidRepo", (Object)this.model.getRepositoryName());
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testInvalidRepositoryNameChange() {
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("InvalidRepo")).thenReturn((Object)false);
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"InvalidRepo");
        this.infoPage.onNameChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).getName();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setNameErrorMessage(Mockito.anyString());
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.never())).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        Assert.assertEquals((Object)"InvalidRepo", (Object)this.model.getRepositoryName());
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testManagedRepositorySelected() {
        this.testManagedRepositoryChange(true);
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.times((int)1))).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
    }

    @Test
    public void testUnManagedRepositorySelected() {
        this.testManagedRepositoryChange(false);
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.never())).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
    }

    private void testManagedRepositoryChange(boolean isManaged) {
        Mockito.when((Object)this.view.isManagedRepository()).thenReturn((Object)isManaged);
        this.infoPage.onManagedRepositoryChange();
        ((RepositoryInfoPageView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)(isManaged ? 4 : 3)))).isManagedRepository();
        Assert.assertEquals((Object)isManaged, (Object)this.model.isManged());
        WizardTestUtils.assertPageComplete(false, (WizardPage)this.infoPage);
    }

    @Test
    public void testPageCompleted() {
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(this.organizationalUnits);
        Mockito.when((Object)this.repositoryService.validateRepositoryName("ValidRepo")).thenReturn((Object)true);
        Mockito.when((Object)this.view.getOrganizationalUnitName()).thenReturn((Object)"OrganizationalUnit1");
        Mockito.when((Object)this.view.getName()).thenReturn((Object)"ValidRepo");
        this.infoPage.prepareView();
        this.infoPage.onNameChange();
        this.infoPage.onOUChange();
        ((WizardTestUtils.WizardPageStatusChangeHandler)Mockito.verify((Object)this.statusChangeHandler, (VerificationMode)Mockito.times((int)2))).handleEvent((WizardPageStatusChangeEvent)Mockito.any(WizardPageStatusChangeEvent.class));
        Assert.assertEquals((Object)this.organizationalUnits.get(0), (Object)this.model.getOrganizationalUnit());
        Assert.assertEquals((Object)"ValidRepo", (Object)this.model.getRepositoryName());
        WizardTestUtils.assertPageComplete(true, (WizardPage)this.infoPage);
    }

    public static List<OrganizationalUnit> buildOrganiztionalUnits() {
        ArrayList<OrganizationalUnit> organizationalUnits = new ArrayList<OrganizationalUnit>();
        OrganizationalUnitImpl organizationalUnit = new OrganizationalUnitImpl("OrganizationalUnit1", "user1", "group1");
        organizationalUnits.add((OrganizationalUnit)organizationalUnit);
        organizationalUnit = new OrganizationalUnitImpl("OrganizationalUnit2", "user2", "group2");
        organizationalUnits.add((OrganizationalUnit)organizationalUnit);
        return organizationalUnits;
    }

    public static List<Pair<String, String>> buildOrganiztionalUnitsInfo(Collection<OrganizationalUnit> organizationalUnits) {
        ArrayList<Pair<String, String>> organizationalUnitsInfo = new ArrayList<Pair<String, String>>();
        for (OrganizationalUnit organizationalUnit : organizationalUnits) {
            organizationalUnitsInfo.add((Pair<String, String>)new Pair((Object)organizationalUnit.getName(), (Object)organizationalUnit.getName()));
        }
        return organizationalUnitsInfo;
    }

    public static class RepositoryInfoPageExtended
    extends RepositoryInfoPage {
        private boolean ouMandatory = false;

        public RepositoryInfoPageExtended(RepositoryInfoPageView view, Caller<OrganizationalUnitService> organizationalUnitService, Caller<RepositoryService> repositoryService, boolean ouMandatory, WizardTestUtils.WizardPageStatusChangeEventMock event) {
            super(view, organizationalUnitService, repositoryService);
            this.ouMandatory = ouMandatory;
            this.wizardPageStatusChangeEvent = event;
            super.init();
        }

        protected boolean isOUMandatory() {
            return this.ouMandatory;
        }
    }
}

