/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.asset.management.client.editors.project.structure.widgets;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataPresenter;
import org.guvnor.asset.management.client.editors.project.structure.widgets.RepositoryStructureDataView;
import org.guvnor.common.services.project.model.GAV;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RepositoryStructureDataPresenterTest {
    @GwtMock
    private Widget widget;
    @Mock
    private RepositoryStructureDataView view;
    private RepositoryStructureDataPresenter presenter;

    @Before
    public void setUp() throws Exception {
        this.presenter = new RepositoryStructureDataPresenter(this.view);
    }

    @Test
    public void testSetGav() throws Exception {
        this.presenter.setGav(new GAV("groupId", "artifactId", "1.0.0"));
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setGroupId("groupId");
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setArtifactId("artifactId");
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setVersion("1.0.0");
    }

    @Test
    public void testGetGav() throws Exception {
        Mockito.when((Object)this.view.getGroupId()).thenReturn((Object)"groupId");
        Mockito.when((Object)this.view.getArtifactId()).thenReturn((Object)"artifactId");
        Mockito.when((Object)this.view.getVersion()).thenReturn((Object)"1.0.0");
        GAV gav = this.presenter.getGav();
        Assert.assertEquals((Object)"groupId", (Object)gav.getGroupId());
        Assert.assertEquals((Object)"artifactId", (Object)gav.getArtifactId());
        Assert.assertEquals((Object)"1.0.0", (Object)gav.getVersion());
    }

    @Test
    public void testConstructor() throws Exception {
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).clear();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setCreateStructureText();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setEditModuleVisibility(Mockito.anyBoolean());
    }

    @Test
    public void testMode_CREATE_STRUCTURE() throws Exception {
        Mockito.reset((Object[])new RepositoryStructureDataView[]{this.view});
        this.presenter.setMode(RepositoryStructureDataView.ViewMode.CREATE_STRUCTURE);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setCreateStructureText();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setEditModuleVisibility(Mockito.anyBoolean());
    }

    @Test
    public void testMode_EDIT_SINGLE_MODULE_PROJECT() throws Exception {
        this.presenter.setMode(RepositoryStructureDataView.ViewMode.EDIT_SINGLE_MODULE_PROJECT);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditSingleModuleProjectText();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditModuleVisibility(true);
    }

    @Test
    public void testMode_EDIT_MULTI_MODULE_PROJECT() throws Exception {
        this.presenter.setMode(RepositoryStructureDataView.ViewMode.EDIT_MULTI_MODULE_PROJECT);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditMultiModuleProjectText();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditModuleVisibility(true);
    }

    @Test
    public void testMode_EDIT_UNMANAGED_REPOSITORY() throws Exception {
        this.presenter.setMode(RepositoryStructureDataView.ViewMode.EDIT_UNMANAGED_REPOSITORY);
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditUnmanagedRepositoryText();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).setEditModuleVisibility(false);
    }

    @Test
    public void testClear() throws Exception {
        Mockito.reset((Object[])new RepositoryStructureDataView[]{this.view});
        this.presenter.clear();
        ((RepositoryStructureDataView)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testAsWidget() throws Exception {
        Mockito.when((Object)this.view.asWidget()).thenReturn((Object)this.widget);
        Assert.assertEquals((Object)this.widget, (Object)this.presenter.asWidget());
    }
}

