/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.guvnor.inbox.backend.server.InboxServiceImpl;
import org.guvnor.inbox.backend.server.PageRowBuilder;
import org.guvnor.inbox.model.InboxIncomingPageRow;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.uberfire.security.Identity;

public class InboxPageRowBuilder
implements PageRowBuilder<InboxPageRequest, Iterator<InboxServiceImpl.InboxEntry>> {
    private InboxPageRequest pageRequest;
    private Iterator<InboxServiceImpl.InboxEntry> iterator;
    private Identity identity;

    @Override
    public List<InboxPageRow> build() {
        this.validate();
        int skipped = 0;
        Integer pageSize = this.pageRequest.getPageSize();
        int startRowIndex = this.pageRequest.getStartRowIndex();
        ArrayList<InboxPageRow> rowList = new ArrayList<InboxPageRow>();
        while (this.iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            InboxServiceImpl.InboxEntry ie = this.iterator.next();
            if (skipped >= startRowIndex) {
                rowList.add(this.createInboxPageRow(ie, this.pageRequest));
            }
            ++skipped;
        }
        return rowList;
    }

    private InboxPageRow createInboxPageRow(InboxServiceImpl.InboxEntry inboxEntry, InboxPageRequest request) {
        InboxPageRow row = null;
        if (request.getInboxName().equals("incoming")) {
            InboxIncomingPageRow tr = new InboxIncomingPageRow();
            tr.setNote(inboxEntry.note);
            tr.setTimestamp(new Date(inboxEntry.timestamp));
            tr.setFrom(inboxEntry.from);
            row = tr;
        } else {
            InboxPageRow tr = new InboxPageRow();
            tr.setNote(inboxEntry.note);
            tr.setTimestamp(new Date(inboxEntry.timestamp));
            row = tr;
        }
        return row;
    }

    @Override
    public void validate() {
        if (this.pageRequest == null) {
            throw new IllegalArgumentException("PageRequest cannot be null");
        }
        if (this.iterator == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
    }

    public InboxPageRowBuilder withPageRequest(InboxPageRequest pageRequest) {
        this.pageRequest = pageRequest;
        return this;
    }

    public InboxPageRowBuilder withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public InboxPageRowBuilder withContent(Iterator<InboxServiceImpl.InboxEntry> iterator) {
        this.iterator = iterator;
        return this;
    }
}

