/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxServiceImpl;
import org.guvnor.inbox.service.InboxService;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MailboxService {
    private static final Logger log = LoggerFactory.getLogger(MailboxService.class);
    private ExecutorService executor = null;
    public static final String MAIL_MAN = "mailman";
    @Inject
    private InboxService inboxService;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    private Path bootstrapRoot = null;

    @PostConstruct
    public void setup() {
        FileSystem bootstrap;
        Iterator rootIterator;
        Iterator fsIterator = this.ioService.getFileSystems((FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE).iterator();
        if (fsIterator.hasNext() && (rootIterator = (bootstrap = (FileSystem)fsIterator.next()).getRootDirectories().iterator()).hasNext()) {
            this.bootstrapRoot = (Path)rootIterator.next();
        }
        this.executor = Executors.newSingleThreadExecutor();
        log.info("mailbox service is up");
        this.wakeUp();
    }

    @PreDestroy
    public void destroy() {
        this.stopExecutor();
    }

    public void stopExecutor() {
        log.info("Shutting down mailbox service");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("Mailbox service is shutdown.");
    }

    public void wakeUp() {
        log.debug("Waking up");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MailboxService.this.processOutgoing();
            }
        });
    }

    void processOutgoing() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List<InboxServiceImpl.InboxEntry> es = ((InboxServiceImpl)MailboxService.this.inboxService).loadIncoming(MailboxService.MAIL_MAN);
                log.debug("Outgoing messages size " + es.size());
                String[] userList = MailboxService.this.listUsers();
                System.out.println("userServices:" + userList.length);
                for (String toUser : userList) {
                    System.out.println("userServices:" + toUser);
                    log.debug("Processing any inbound messages for " + toUser);
                    if (toUser.equals(MailboxService.MAIL_MAN)) {
                        return;
                    }
                    Set recentEdited = MailboxService.this.makeSetOf(((InboxServiceImpl)MailboxService.this.inboxService).loadRecentEdited(toUser));
                    for (InboxServiceImpl.InboxEntry e : es) {
                        if (e.from.equals(toUser) || !recentEdited.contains(e.itemPath)) continue;
                        ((InboxServiceImpl)MailboxService.this.inboxService).addToIncoming(e.itemPath, e.note, e.from, toUser);
                    }
                }
            }
        });
    }

    private Set<String> makeSetOf(List<InboxServiceImpl.InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (InboxServiceImpl.InboxEntry e : inboxEntries) {
            entries.add(e.itemPath);
        }
        return entries;
    }

    public String[] listUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        Path userRoot = this.bootstrapRoot.resolve("/.metadata/.users/");
        Iterator userIterator = userRoot.iterator();
        if (userIterator.hasNext()) {
            Path userDir = (Path)userIterator.next();
            userList.add(userDir.getFileName().toString());
        }
        String[] result = new String[userList.size()];
        return userList.toArray(result);
    }
}

