/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.InboxPageRowBuilder;
import org.guvnor.inbox.backend.server.PageResponseBuilder;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.guvnor.inbox.service.InboxService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.paging.PageResponse;
import org.uberfire.security.Identity;

@Service
@ApplicationScoped
public class InboxServiceImpl
implements InboxService {
    @Inject
    @SessionScoped
    private Identity identity;
    @Inject
    private InboxBackend backend;

    public PageResponse<InboxPageRow> loadInbox(InboxPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        String inboxName = request.getInboxName();
        List<InboxEntry> entries = this.loadEntries(inboxName);
        Iterator<InboxEntry> iterator = entries.iterator();
        List<InboxPageRow> rowList = new InboxPageRowBuilder().withPageRequest(request).withIdentity(this.identity).withContent(iterator).build();
        return new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(entries.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(!iterator.hasNext()).build();
    }

    private List<InboxEntry> loadEntries(String inboxName) {
        List<InboxEntry> entries = inboxName.equals("recentViewed") ? this.loadRecentOpened() : (inboxName.equals("recentEdited") ? this.loadRecentEdited() : this.loadIncoming());
        return entries;
    }

    private List<InboxEntry> loadRecentEdited() {
        return this.backend.readEntries(this.identity.getName(), "recentEdited");
    }

    private List<InboxEntry> loadRecentOpened() {
        return this.backend.readEntries(this.identity.getName(), "recentViewed");
    }

    private List<InboxEntry> loadIncoming() {
        return this.backend.readEntries(this.identity.getName(), "incoming");
    }
}

