/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.FileSystemType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class MailboxService {
    private static final Logger log = LoggerFactory.getLogger(MailboxService.class);
    private ExecutorService executor = null;
    public static final String MAIL_MAN = "mailman";
    @Inject
    private InboxBackend inboxBackend;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    private FileSystem bootstrapFS = null;

    @PostConstruct
    public void setup() {
        Iterator fsIterator = this.ioService.getFileSystems((FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE).iterator();
        if (fsIterator.hasNext()) {
            this.bootstrapFS = (FileSystem)fsIterator.next();
        }
        this.executor = Executors.newSingleThreadExecutor();
        log.info("mailbox service is up");
        this.wakeUp();
    }

    @PreDestroy
    public void destroy() {
        this.stopExecutor();
    }

    public void stopExecutor() {
        log.info("Shutting down mailbox service");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("Mailbox service is shutdown.");
    }

    public void wakeUp() {
        log.debug("Waking up");
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                MailboxService.this.processOutgoing();
            }
        });
    }

    void processOutgoing() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                List<InboxEntry> es = MailboxService.this.inboxBackend.loadIncoming(MailboxService.MAIL_MAN);
                log.debug("Outgoing messages size " + es.size());
                String[] userList = MailboxService.this.listUsers();
                System.out.println("userServices:" + userList.length);
                for (String toUser : userList) {
                    System.out.println("userServices:" + toUser);
                    log.debug("Processing any inbound messages for " + toUser);
                    if (toUser.equals(MailboxService.MAIL_MAN)) {
                        return;
                    }
                    Set recentEdited = MailboxService.this.makeSetOf(MailboxService.this.inboxBackend.loadRecentEdited(toUser));
                    for (InboxEntry e : es) {
                        if (e.getFrom().equals(toUser) || !recentEdited.contains(e.getItemPath())) continue;
                        MailboxService.this.inboxBackend.addToIncoming(e.getItemPath(), e.getNote(), e.getFrom(), toUser);
                    }
                }
            }
        });
    }

    private Set<String> makeSetOf(List<InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (InboxEntry e : inboxEntries) {
            entries.add(e.getItemPath());
        }
        return entries;
    }

    public String[] listUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        for (Path path : this.bootstrapFS.getRootDirectories()) {
            String value = path.toUri().getUserInfo();
            if (!value.endsWith("-uf-user")) continue;
            userList.add(value.substring(0, value.indexOf("-uf-user")));
        }
        return userList.toArray(new String[userList.size()]);
    }
}

