/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import org.guvnor.inbox.backend.server.AsyncMailboxProcessOutgoing;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.MailboxProcessOutgoingExecutorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class MailboxService {
    private static final Logger log = LoggerFactory.getLogger(MailboxService.class);
    private MailboxProcessOutgoingExecutorManager executorManager = null;
    public static final String MAIL_MAN = "mailman";
    @Inject
    private InboxBackend inboxBackend;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem bootstrapFS;

    @PostConstruct
    public void setup() {
        log.info("mailbox service is up");
        this.processOutgoing();
    }

    @PreDestroy
    public void destroy() {
        this.stopExecutor();
    }

    private void stopExecutor() {
        if (this.executorManager != null && !this.isEjb(this.executorManager, MailboxProcessOutgoingExecutorManager.class)) {
            log.info("Shutting down mailbox service");
            this.executorManager.shutdown();
            log.info("Mailbox service is shutdown.");
        }
    }

    private boolean isEjb(Object o, Class<?> expected) {
        return o.getClass() != expected;
    }

    void processOutgoing() {
        this.getExecutor().execute(new AsyncMailboxProcessOutgoing(){

            @Override
            public String getDescription() {
                return "Mailbox Outgoing Processing";
            }

            @Override
            public void execute(InboxBackend inboxBackend) {
                List<InboxEntry> es = inboxBackend.loadIncoming(MailboxService.MAIL_MAN);
                log.debug("Outgoing messages size " + es.size());
                String[] userList = MailboxService.this.listUsers();
                log.debug("userServices:" + userList.length);
                for (String toUser : userList) {
                    log.debug("userServices:" + toUser);
                    log.debug("Processing any inbound messages for " + toUser);
                    if (toUser.equals(MailboxService.MAIL_MAN)) {
                        return;
                    }
                    Set recentEdited = MailboxService.this.makeSetOf(inboxBackend.loadRecentEdited(toUser));
                    for (InboxEntry e : es) {
                        if (e.getFrom().equals(toUser) || !recentEdited.contains(e.getItemPath())) continue;
                        inboxBackend.addToIncoming(e.getItemPath(), e.getNote(), e.getFrom(), toUser);
                    }
                }
            }
        });
    }

    private synchronized MailboxProcessOutgoingExecutorManager getExecutor() {
        if (this.executorManager == null) {
            MailboxProcessOutgoingExecutorManager _executorManager = null;
            try {
                _executorManager = (MailboxProcessOutgoingExecutorManager)InitialContext.doLookup("java:module/MailboxProcessOutgoingExecutorManager");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (_executorManager == null) {
                this.executorManager = new MailboxProcessOutgoingExecutorManager();
                this.executorManager.setInboxBackend(this.inboxBackend);
            } else {
                this.executorManager = _executorManager;
            }
        }
        return this.executorManager;
    }

    private Set<String> makeSetOf(List<InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (InboxEntry e : inboxEntries) {
            entries.add(e.getItemPath());
        }
        return entries;
    }

    public String[] listUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        for (Path path : this.bootstrapFS.getRootDirectories()) {
            String value = path.toUri().getUserInfo();
            if (!value.endsWith("-uf-user")) continue;
            userList.add(value.substring(0, value.indexOf("-uf-user")));
        }
        return userList.toArray(new String[userList.size()]);
    }
}

