/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class MailboxService {
    private static final Logger log = LoggerFactory.getLogger(MailboxService.class);
    public static final String MAIL_MAN = "mailman";
    @Inject
    private InboxBackend inboxBackend;
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    @Named(value="systemFS")
    private FileSystem bootstrapFS;

    @PostConstruct
    public void setup() {
        log.info("mailbox service is up");
        this.processOutgoing();
    }

    void processOutgoing() {
        List<InboxEntry> es = this.inboxBackend.loadIncoming(MAIL_MAN);
        log.debug("Outgoing messages size " + es.size());
        String[] userList = this.listUsers();
        log.debug("userServices:" + userList.length);
        for (String toUser : userList) {
            log.debug("userServices:" + toUser);
            log.debug("Processing any inbound messages for " + toUser);
            if (toUser.equals(MAIL_MAN)) {
                return;
            }
            Set<String> recentEdited = this.makeSetOf(this.inboxBackend.loadRecentEdited(toUser));
            for (InboxEntry e : es) {
                if (e.getFrom().equals(toUser) || !recentEdited.contains(e.getItemPath())) continue;
                this.inboxBackend.addToIncoming(e.getItemPath(), e.getNote(), e.getFrom(), toUser);
            }
        }
    }

    private Set<String> makeSetOf(List<InboxEntry> inboxEntries) {
        HashSet<String> entries = new HashSet<String>();
        for (InboxEntry e : inboxEntries) {
            entries.add(e.getItemPath());
        }
        return entries;
    }

    public String[] listUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        for (Path path : this.bootstrapFS.getRootDirectories()) {
            String value = path.toUri().getUserInfo();
            if (value == null || !value.endsWith("-uf-user")) continue;
            userList.add(value.substring(0, value.indexOf("-uf-user")));
        }
        return userList.toArray(new String[userList.size()]);
    }
}

