/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.MailboxService;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class InboxBackendImpl
implements InboxBackend {
    static final int MAX_RECENT_EDITED = 200;
    private static final String RECENT_EDITED_ID = "recentEdited";
    private static final String RECENT_VIEWED_ID = "recentViewed";
    private static final String INCOMING_ID = "incoming";
    private static final String INBOX = "inbox";
    private IOService ioService;
    private FileSystem bootstrapFS;
    private UserServicesBackendImpl userServicesBackend;
    private MailboxService mailboxService;

    public InboxBackendImpl() {
    }

    @Inject
    public InboxBackendImpl(@Named(value="configIO") IOService ioService, @Named(value="systemFS") FileSystem bootstrapFS, UserServicesBackendImpl userServicesBackend, MailboxService mailboxService) {
        this.ioService = ioService;
        this.bootstrapFS = bootstrapFS;
        this.userServicesBackend = userServicesBackend;
        this.mailboxService = mailboxService;
    }

    @Override
    public List<InboxEntry> loadRecentEdited(String userName) {
        return this.readEntries(userName, RECENT_EDITED_ID);
    }

    @Override
    public List<InboxEntry> loadIncoming(String userName) {
        return this.readEntries(userName, INCOMING_ID);
    }

    @Override
    public List<InboxEntry> readEntries(String userName, String boxName) {
        Path path = this.userServicesBackend.buildPath(userName, INBOX, boxName);
        if (this.ioService.exists(path)) {
            String xml = this.ioService.readAllString(path);
            if (xml != null && !xml.equals("")) {
                return (List)this.getXStream().fromXML(xml);
            }
            return new ArrayList<InboxEntry>();
        }
        return new ArrayList<InboxEntry>();
    }

    @Override
    public void addToIncoming(String itemPath, String note, String userFrom, String userName) {
        this.addToInbox(INCOMING_ID, itemPath, note, userFrom, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordOpeningEvent(@Observes ResourceOpenedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        org.uberfire.backend.vfs.Path resourcePath = event.getPath();
        try {
            this.ioService.startBatch(((Path)this.bootstrapFS.getRootDirectories().iterator().next()).getFileSystem());
            this.recordOpeningEvent(resourcePath.toURI(), resourcePath.getFileName().toString(), event.getSessionInfo().getIdentity().getIdentifier());
        }
        finally {
            this.ioService.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordUserEditEvent(@Observes ResourceUpdatedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        try {
            this.ioService.startBatch(((Path)this.bootstrapFS.getRootDirectories().iterator().next()).getFileSystem());
            this.recordUserEditEvent(event.getPath().toURI(), event.getPath().getFileName(), event.getSessionInfo().getIdentity().getIdentifier());
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void recordOpeningEvent(String itemPath, String itemName, String userName) {
        this.addToRecentOpened(itemPath, itemName, userName);
        List<InboxEntry> unreadIncoming = this.removeAnyExisting(itemPath, this.loadIncoming(userName));
        this.writeEntries(userName, INCOMING_ID, unreadIncoming);
    }

    private void recordUserEditEvent(String itemPath, String itemName, String userName) {
        this.addToRecentEdited(itemPath, itemName, userName);
        this.addToIncoming(itemPath, itemName, userName, "mailman");
        this.mailboxService.processOutgoing();
    }

    private void addToRecentEdited(String itemPath, String note, String userName) {
        this.addToInbox(RECENT_EDITED_ID, itemPath, note, userName, userName);
    }

    private void addToRecentOpened(String itemPath, String note, String userName) {
        this.addToInbox(RECENT_VIEWED_ID, itemPath, note, userName, userName);
    }

    private void addToInbox(String boxName, String itemPath, String note, String userFrom, String userName) {
        assert (boxName.equals(RECENT_EDITED_ID) || boxName.equals(RECENT_VIEWED_ID) || boxName.equals(INCOMING_ID));
        List<InboxEntry> entries = this.removeAnyExisting(itemPath, this.readEntries(userName, boxName));
        if (entries.size() >= 200) {
            entries.remove(0);
            entries.add(new InboxEntry(itemPath, note, userFrom));
        } else {
            entries.add(new InboxEntry(itemPath, note, userFrom));
        }
        this.writeEntries(userName, boxName, entries);
    }

    private List<InboxEntry> removeAnyExisting(String itemPath, List<InboxEntry> inboxEntries) {
        Iterator<InboxEntry> it = inboxEntries.iterator();
        while (it.hasNext()) {
            InboxEntry e = it.next();
            if (!e.getItemPath().equals(itemPath)) continue;
            it.remove();
            return inboxEntries;
        }
        return inboxEntries;
    }

    private void writeEntries(String userName, String boxName, List<InboxEntry> entries) {
        Path path = this.userServicesBackend.buildPath(userName, INBOX, boxName);
        String entry = this.getXStream().toXML(entries);
        this.ioService.write(path, entry, new OpenOption[0]);
    }

    private XStream getXStream() {
        XStream xs = new XStream();
        xs.alias("inbox-entries", List.class);
        xs.alias("entry", InboxEntry.class);
        return xs;
    }
}

