/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.guvnor.inbox.backend.server.InboxBackendImpl;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.MailboxService;
import org.guvnor.inbox.backend.server.security.InboxEntrySecurity;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.UserServicesBackendImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

public class InboxBackendImplTest {
    private InboxBackendImpl inboxBackend;
    private org.uberfire.backend.vfs.Path resourcePath;
    private SessionInfo sessionInfo;
    private FileSystem mockedFSId;
    private IOService ioService;
    private InboxEntrySecurity securitySpy;
    private UserServicesBackendImpl userServicesBackend;
    private MailboxService mailboxService;
    private FileSystem systemFS;

    @Before
    public void setup() {
        this.ioService = (IOService)Mockito.mock(IOService.class);
        this.systemFS = (FileSystem)Mockito.mock(FileSystem.class);
        InboxEntrySecurity security = new InboxEntrySecurity(){

            public List<InboxEntry> secure(List<InboxEntry> inboxEntries) {
                return inboxEntries;
            }
        };
        this.securitySpy = (InboxEntrySecurity)Mockito.spy((Object)security);
        this.userServicesBackend = (UserServicesBackendImpl)Mockito.mock(UserServicesBackendImpl.class);
        this.mailboxService = (MailboxService)Mockito.mock(MailboxService.class);
        this.sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)user);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        this.resourcePath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Mockito.when((Object)this.resourcePath.toURI()).thenReturn((Object)URI.create("jgit://repo/my-file.txt").toString());
        Mockito.when((Object)this.resourcePath.getFileName()).thenReturn((Object)"my-file.txt");
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.systemFS.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)this.mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)this.mockedFSId);
        Mockito.when((Object)((FileSystemId)this.mockedFSId).id()).thenReturn((Object)"my-fsid");
    }

    @Test
    public void testCheckBatch() {
        this.inboxBackend = new InboxBackendImpl(this.ioService, this.systemFS, this.userServicesBackend, this.mailboxService, this.securitySpy);
        this.inboxBackend.recordOpeningEvent(new ResourceOpenedEvent(this.resourcePath, this.sessionInfo));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch(this.mockedFSId);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
        this.inboxBackend.recordUserEditEvent(new ResourceUpdatedEvent(this.resourcePath, "message", this.sessionInfo));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).startBatch(this.mockedFSId);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).endBatch();
    }

    @Test
    public void readShouldSecureItems() {
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)this.userServicesBackend.buildPath("userName", "inbox", "boxName")).thenReturn((Object)path);
        Mockito.when((Object)this.ioService.exists(path)).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString(path)).thenReturn((Object)" ");
        final ArrayList<InboxEntry> entries = new ArrayList<InboxEntry>();
        InboxEntry inboxEntry1 = new InboxEntry("path1", "note1", "user1");
        entries.add(inboxEntry1);
        this.inboxBackend = new InboxBackendImpl(this.ioService, this.systemFS, this.userServicesBackend, this.mailboxService, this.securitySpy){

            List<InboxEntry> getInboxEntries(String xml) {
                return entries;
            }
        };
        this.inboxBackend.readEntries("userName", "boxName");
        ((InboxEntrySecurity)Mockito.verify((Object)this.securitySpy)).secure(entries);
    }
}

