/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server.security;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.security.InboxEntrySecurity;
import org.guvnor.structure.backend.repositories.RepositoryServiceImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class InboxEntrySecurityTest {
    private Repository repo1;
    private Repository repo2;
    private User user;
    private AuthorizationManager authorizationManager;
    private OrganizationalUnitService organizationalUnitService;
    private ProjectService<? extends Project> projectService;
    private RepositoryServiceImpl repositoryService;
    private Project project1;

    @Before
    public void setup() {
        this.user = (User)Mockito.mock(User.class);
        this.authorizationManager = (AuthorizationManager)Mockito.mock(AuthorizationManager.class);
        this.organizationalUnitService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
        ArrayList<OrganizationalUnit> ous = new ArrayList<OrganizationalUnit>();
        OrganizationalUnit ou = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        ous.add(ou);
        Mockito.when((Object)this.organizationalUnitService.getOrganizationalUnits()).thenReturn(ous);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)ou, this.user)).thenReturn((Object)true);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        this.repo1 = (Repository)Mockito.mock(Repository.class);
        this.repo2 = (Repository)Mockito.mock(Repository.class);
        this.project1 = (Project)Mockito.mock(Project.class);
        repositories.add(this.repo1);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)this.repo1, this.user)).thenReturn((Object)true);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)this.project1, this.user)).thenReturn((Object)true);
        Mockito.when((Object)ou.getRepositories()).thenReturn(repositories);
        this.projectService = null;
        this.repositoryService = null;
    }

    @Test
    public void testSecureNullRepoNullProject() throws Exception {
        InboxEntrySecurity inbox = new InboxEntrySecurity(this.user, this.authorizationManager, this.organizationalUnitService, this.projectService, this.repositoryService){

            Repository getInboxEntryRepository(InboxEntry inboxEntry) {
                return null;
            }

            Project getInboxEntryProject(InboxEntry inboxEntry) {
                return null;
            }
        };
        ArrayList<InboxEntry> entries = new ArrayList<InboxEntry>();
        InboxEntry inboxEntry1 = new InboxEntry("path1", "note1", "user1");
        InboxEntry inboxEntry2 = new InboxEntry("path2", "note2", "user2");
        InboxEntry inboxEntry3 = new InboxEntry("path3", "note3", "user3");
        entries.add(inboxEntry1);
        entries.add(inboxEntry2);
        entries.add(inboxEntry3);
        TestCase.assertEquals((int)entries.size(), (int)inbox.secure(entries).size());
    }

    @Test
    public void testSecureRepoWithoutProject() throws Exception {
        InboxEntrySecurity inbox = new InboxEntrySecurity(this.user, this.authorizationManager, this.organizationalUnitService, this.projectService, this.repositoryService){

            Repository getInboxEntryRepository(InboxEntry inboxEntry) {
                if (inboxEntry.getItemPath().equals("path1")) {
                    return InboxEntrySecurityTest.this.repo2;
                }
                return InboxEntrySecurityTest.this.repo1;
            }

            Project getInboxEntryProject(InboxEntry inboxEntry) {
                return null;
            }
        };
        ArrayList<InboxEntry> entries = new ArrayList<InboxEntry>();
        InboxEntry inboxEntry1 = new InboxEntry("path1", "note1", "user1");
        InboxEntry inboxEntry2 = new InboxEntry("path2", "note2", "user2");
        InboxEntry inboxEntry3 = new InboxEntry("path3", "note3", "user3");
        entries.add(inboxEntry1);
        entries.add(inboxEntry2);
        entries.add(inboxEntry3);
        TestCase.assertEquals((int)2, (int)inbox.secure(entries).size());
    }

    @Test
    public void testSecureRepoInsecureProject() throws Exception {
        InboxEntrySecurity inbox = new InboxEntrySecurity(this.user, this.authorizationManager, this.organizationalUnitService, this.projectService, this.repositoryService){

            Repository getInboxEntryRepository(InboxEntry inboxEntry) {
                return InboxEntrySecurityTest.this.repo1;
            }

            Project getInboxEntryProject(InboxEntry inboxEntry) {
                return (Project)Mockito.mock(Project.class);
            }
        };
        ArrayList<InboxEntry> entries = new ArrayList<InboxEntry>();
        InboxEntry inboxEntry1 = new InboxEntry("path1", "note1", "user1");
        InboxEntry inboxEntry2 = new InboxEntry("path2", "note2", "user2");
        InboxEntry inboxEntry3 = new InboxEntry("path3", "note3", "user3");
        entries.add(inboxEntry1);
        entries.add(inboxEntry2);
        entries.add(inboxEntry3);
        TestCase.assertEquals((int)0, (int)inbox.secure(entries).size());
    }

    @Test
    public void testSecureRepoSecureProject() throws Exception {
        InboxEntrySecurity inbox = new InboxEntrySecurity(this.user, this.authorizationManager, this.organizationalUnitService, this.projectService, this.repositoryService){

            Repository getInboxEntryRepository(InboxEntry inboxEntry) {
                return InboxEntrySecurityTest.this.repo1;
            }

            Project getInboxEntryProject(InboxEntry inboxEntry) {
                return InboxEntrySecurityTest.this.project1;
            }
        };
        ArrayList<InboxEntry> entries = new ArrayList<InboxEntry>();
        InboxEntry inboxEntry1 = new InboxEntry("path1", "note1", "user1");
        InboxEntry inboxEntry2 = new InboxEntry("path2", "note2", "user2");
        InboxEntry inboxEntry3 = new InboxEntry("path3", "note3", "user3");
        entries.add(inboxEntry1);
        entries.add(inboxEntry2);
        entries.add(inboxEntry3);
        TestCase.assertEquals((int)3, (int)inbox.secure(entries).size());
    }
}

