/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.net.URI;
import java.util.Arrays;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.MailboxService;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

public class MailboxServiceTest {
    @Test
    public void testCheckBatch() {
        IOService ioService = (IOService)Mockito.mock(IOService.class);
        FileSystem systemFS = (FileSystem)Mockito.mock(FileSystem.class);
        SessionInfo sessionInfo = (SessionInfo)Mockito.mock(SessionInfo.class);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)sessionInfo.getIdentity()).thenReturn((Object)user);
        Mockito.when((Object)user.getIdentifier()).thenReturn((Object)"user1");
        org.uberfire.backend.vfs.Path resourcePath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Mockito.when((Object)resourcePath.toURI()).thenReturn((Object)URI.create("jgit://repo/my-file.txt").toString());
        Mockito.when((Object)resourcePath.getFileName()).thenReturn((Object)"my-file.txt");
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)systemFS.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        Mockito.when((Object)((FileSystemId)mockedFSId).id()).thenReturn((Object)"my-fsid");
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("jgit://user1-uf-user@sss"));
        MailboxService inboxBackend = new MailboxService((InboxBackend)Mockito.mock(InboxBackend.class), ioService, systemFS);
        inboxBackend.setup();
        ((IOService)Mockito.verify((Object)ioService, (VerificationMode)Mockito.times((int)1))).startBatch(mockedFSId);
        ((IOService)Mockito.verify((Object)ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }
}

