/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class InboxEntrySecurity {
    private User identity;
    private AuthorizationManager authorizationManager;
    private OrganizationalUnitService organizationalUnitService;
    private ProjectService<? extends Project> projectService;
    private ConfiguredRepositories configuredRepositories;

    public InboxEntrySecurity() {
    }

    @Inject
    public InboxEntrySecurity(User identity, AuthorizationManager authorizationManager, OrganizationalUnitService organizationalUnitService, ProjectService<? extends Project> projectService, ConfiguredRepositories configuredRepositories) {
        this.identity = identity;
        this.authorizationManager = authorizationManager;
        this.organizationalUnitService = organizationalUnitService;
        this.projectService = projectService;
        this.configuredRepositories = configuredRepositories;
    }

    public List<InboxEntry> secure(List<InboxEntry> inboxEntries) {
        ArrayList<InboxEntry> secureInboxEntries = new ArrayList<InboxEntry>();
        Set<Repository> authorizedRepositories = this.getAuthorizedRepositories();
        for (InboxEntry inboxEntry : inboxEntries) {
            if (!this.canAccess(inboxEntry, authorizedRepositories)) continue;
            secureInboxEntries.add(inboxEntry);
        }
        return secureInboxEntries;
    }

    private boolean canAccess(InboxEntry inboxEntry, Set<Repository> authorizedRepositories) {
        Repository inboxEntryRepository = this.getInboxEntryRepository(inboxEntry);
        if (this.thereIsNoRepositoryAssociated(inboxEntryRepository)) {
            return true;
        }
        if (this.canAccessRepository(authorizedRepositories, inboxEntryRepository)) {
            return this.canAccessProject(inboxEntry);
        }
        return false;
    }

    private boolean canAccessProject(InboxEntry inboxEntry) {
        Project project = this.getInboxEntryProject(inboxEntry);
        if (this.thereIsNoProject(project)) {
            return true;
        }
        return this.authorizationManager.authorize((Resource)project, this.identity);
    }

    private boolean thereIsNoProject(Project project) {
        return project == null;
    }

    private boolean canAccessRepository(Set<Repository> authorizedRepositories, Repository inboxEntryRepository) {
        return authorizedRepositories.contains(inboxEntryRepository);
    }

    Project getInboxEntryProject(InboxEntry inboxEntry) {
        Path path = Paths.get((String)inboxEntry.getItemPath(), (String[])new String[0]);
        org.uberfire.backend.vfs.Path vfsPath = org.uberfire.backend.server.util.Paths.convert((Path)path);
        return this.projectService.resolveProject(vfsPath);
    }

    private boolean thereIsNoRepositoryAssociated(Repository inboxEntryRepository) {
        return inboxEntryRepository == null;
    }

    Repository getInboxEntryRepository(InboxEntry inboxEntry) {
        Path path = Paths.get((String)inboxEntry.getItemPath(), (String[])new String[0]);
        FileSystem fileSystem = path.getFileSystem();
        return this.configuredRepositories.getRepositoryByRepositoryFileSystem(fileSystem);
    }

    private Set<Repository> getAuthorizedRepositories() {
        HashSet<Repository> authorizedRepos = new HashSet<Repository>();
        for (OrganizationalUnit ou : this.getAuthorizedOrganizationUnits()) {
            Collection repositories = ou.getRepositories();
            for (Repository repository : repositories) {
                if (!this.authorizationManager.authorize((Resource)repository, this.identity)) continue;
                authorizedRepos.add(repository);
            }
        }
        return authorizedRepos;
    }

    private Collection<OrganizationalUnit> getAuthorizedOrganizationUnits() {
        Collection organizationalUnits = this.organizationalUnitService.getOrganizationalUnits();
        ArrayList<OrganizationalUnit> authorizedOrganizationalUnits = new ArrayList<OrganizationalUnit>();
        for (OrganizationalUnit ou : organizationalUnits) {
            if (!this.authorizationManager.authorize((Resource)ou, this.identity)) continue;
            authorizedOrganizationalUnits.add(ou);
        }
        return authorizedOrganizationalUnits;
    }
}

