/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.inbox.backend.server;

import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.inbox.backend.server.InboxBackend;
import org.guvnor.inbox.backend.server.InboxEntry;
import org.guvnor.inbox.backend.server.InboxPageRowBuilder;
import org.guvnor.inbox.backend.server.PageResponseBuilder;
import org.guvnor.inbox.model.InboxPageRequest;
import org.guvnor.inbox.model.InboxPageRow;
import org.guvnor.inbox.service.InboxService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.paging.PageResponse;

@Service
@ApplicationScoped
public class InboxServiceImpl
implements InboxService {
    @Inject
    private User identity;
    @Inject
    private InboxBackend inboxBackend;
    @Inject
    private InboxPageRowBuilder inboxPageRowBuilder;

    public PageResponse<InboxPageRow> loadInbox(InboxPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        String inboxName = request.getInboxName();
        PageResponse<InboxPageRow> response = new PageResponse<InboxPageRow>();
        List<InboxEntry> entries = this.loadEntries(inboxName);
        Iterator<InboxEntry> iterator = entries.iterator();
        List<InboxPageRow> rowList = this.inboxPageRowBuilder.withPageRequest(request).withIdentity(this.identity).withContent(iterator).build();
        response = new PageResponseBuilder().withStartRowIndex(request.getStartRowIndex()).withTotalRowSize(entries.size()).withTotalRowSizeExact().withPageRowList(rowList).withLastPage(!iterator.hasNext()).build();
        return response;
    }

    private List<InboxEntry> loadEntries(String inboxName) {
        List<InboxEntry> entries = inboxName.equals("recentViewed") ? this.loadRecentOpened() : (inboxName.equals("recentEdited") ? this.loadRecentEdited() : this.loadIncoming());
        return entries;
    }

    private List<InboxEntry> loadRecentEdited() {
        return this.inboxBackend.readEntries(this.identity.getIdentifier(), "recentEdited");
    }

    private List<InboxEntry> loadRecentOpened() {
        return this.inboxBackend.readEntries(this.identity.getIdentifier(), "recentViewed");
    }

    private List<InboxEntry> loadIncoming() {
        return this.inboxBackend.readEntries(this.identity.getIdentifier(), "incoming");
    }
}

