/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.messageconsole.client.console.MessageConsoleServiceRow;
import org.guvnor.messageconsole.events.PublishBaseEvent;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.PublishMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.messageconsole.events.UnpublishMessagesEvent;
import org.guvnor.messageconsole.whitelist.MessageConsoleWhiteList;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.rpc.SessionInfo;

@ApplicationScoped
public class MessageConsoleService {
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private SessionInfo sessionInfo;
    @Inject
    private User identity;
    private ListDataProvider<MessageConsoleServiceRow> dataProvider = new ListDataProvider();
    private static final String MESSAGE_CONSOLE = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    private String currentPerspective;

    public void publishMessages(@Observes PublishMessagesEvent publishEvent) {
        this.publishMessages(publishEvent.getSessionId(), publishEvent.getUserId(), publishEvent.getPlace(), publishEvent.getMessagesToPublish());
        if (publishEvent.isShowSystemConsole() && this.checkWhiteList()) {
            this.placeManager.goTo(MESSAGE_CONSOLE);
        }
    }

    public void unpublishMessages(@Observes UnpublishMessagesEvent unpublishEvent) {
        this.unpublishMessages(unpublishEvent.getSessionId(), unpublishEvent.getUserId(), unpublishEvent.getMessageType(), unpublishEvent.getMessagesToUnpublish());
        if (unpublishEvent.isShowSystemConsole() && this.checkWhiteList()) {
            this.placeManager.goTo(MESSAGE_CONSOLE);
        }
    }

    public void publishBatchMessages(@Observes PublishBatchMessagesEvent publishBatchEvent) {
        if (publishBatchEvent.isCleanExisting()) {
            this.unpublishMessages(publishBatchEvent.getSessionId(), publishBatchEvent.getUserId(), publishBatchEvent.getMessageType(), publishBatchEvent.getMessagesToUnpublish());
        } else {
            this.removeRowsByMessage(publishBatchEvent.getMessagesToUnpublish());
        }
        this.publishMessages(publishBatchEvent.getSessionId(), publishBatchEvent.getUserId(), publishBatchEvent.getPlace(), publishBatchEvent.getMessagesToPublish());
        if (publishBatchEvent.isShowSystemConsole() && this.checkWhiteList()) {
            this.placeManager.goTo(MESSAGE_CONSOLE);
        }
    }

    public void addDataDisplay(HasData<MessageConsoleServiceRow> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public void onPerspectiveChange(@Observes PerspectiveChange perspectiveChange) {
        this.currentPerspective = perspectiveChange.getIdentifier();
    }

    private void publishMessages(String sessionId, String userId, PublishBaseEvent.Place place, List<SystemMessage> messages) {
        List list = this.dataProvider.getList();
        List<SystemMessage> newMessages = this.filterMessages(sessionId, userId, null, messages);
        ArrayList<MessageConsoleServiceRow> newRows = new ArrayList<MessageConsoleServiceRow>();
        int index = place != null && place == PublishBaseEvent.Place.TOP ? 0 : (list != null && list.size() > 0 ? list.size() : 0);
        for (SystemMessage systemMessage : newMessages) {
            newRows.add(new MessageConsoleServiceRow(sessionId, userId, systemMessage));
        }
        list.addAll(index, newRows);
    }

    private void unpublishMessages(String sessionId, String userId, String messageType, List<SystemMessage> messages) {
        String currentSessionId = this.sessionInfo != null ? this.sessionInfo.getId() : null;
        String currentUserId = this.identity != null ? this.identity.getIdentifier() : null;
        ArrayList<MessageConsoleServiceRow> rowsToDelete = new ArrayList<MessageConsoleServiceRow>();
        for (MessageConsoleServiceRow row : this.dataProvider.getList()) {
            if (sessionId == null && userId == null) {
                if (messageType != null && !messageType.equals(row.getMessageType())) continue;
                rowsToDelete.add(row);
                continue;
            }
            if (sessionId != null) {
                if (!sessionId.equals(currentSessionId) || messageType != null && !messageType.equals(row.getMessageType())) continue;
                rowsToDelete.add(row);
                continue;
            }
            if (!userId.equals(currentUserId) || messageType != null && !messageType.equals(row.getMessageType())) continue;
            rowsToDelete.add(row);
        }
        this.dataProvider.getList().removeAll(rowsToDelete);
        this.removeRowsByMessage(messages);
    }

    private void removeRowsByMessage(List<SystemMessage> messages) {
        ArrayList<MessageConsoleServiceRow> rowsToDelete = new ArrayList<MessageConsoleServiceRow>();
        if (messages != null) {
            for (MessageConsoleServiceRow row : this.dataProvider.getList()) {
                if (!messages.contains(row.getMessage())) continue;
                rowsToDelete.add(row);
            }
            this.dataProvider.getList().removeAll(rowsToDelete);
        }
    }

    private List<SystemMessage> filterMessages(String sessionId, String userId, String messageType, List<SystemMessage> messages) {
        String currentUserId;
        ArrayList<SystemMessage> result = new ArrayList<SystemMessage>();
        String currentSessionId = this.sessionInfo != null ? this.sessionInfo.getId() : null;
        String string = currentUserId = this.identity != null ? this.identity.getIdentifier() : null;
        if (messages != null) {
            for (SystemMessage message : messages) {
                if (sessionId == null && userId == null) {
                    if (messageType != null && !messageType.equals(message.getMessageType())) continue;
                    result.add(message);
                    continue;
                }
                if (sessionId != null) {
                    if (!sessionId.equals(currentSessionId) || messageType != null && !messageType.equals(message.getMessageType())) continue;
                    result.add(message);
                    continue;
                }
                if (!userId.equals(currentUserId) || messageType != null && !messageType.equals(message.getMessageType())) continue;
                result.add(message);
            }
        }
        return result;
    }

    private boolean checkWhiteList() {
        Collection<IOCBeanDef<MessageConsoleWhiteList>> whiteListList = this.getAvailableWhiteLists();
        if (whiteListList.isEmpty()) {
            return true;
        }
        return ((MessageConsoleWhiteList)this.reLookupBean(whiteListList.iterator().next()).getInstance()).contains(this.currentPerspective);
    }

    private IOCBeanDef<MessageConsoleWhiteList> reLookupBean(IOCBeanDef<MessageConsoleWhiteList> baseBean) {
        return this.iocManager.lookupBean(baseBean.getBeanClass(), new Annotation[0]);
    }

    private Collection<IOCBeanDef<MessageConsoleWhiteList>> getAvailableWhiteLists() {
        return this.iocManager.lookupBeans(MessageConsoleWhiteList.class);
    }
}

