/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.guvnor.common.services.project.events;

import org.guvnor.common.services.project.model.Package;

/**
 * An event raised when the Package in File Explorer (or any equivalent widget) changes
 */
public class PackageChangeEvent {

    private final org.guvnor.common.services.project.model.Package pkg;

    public PackageChangeEvent() {
        pkg = null;
    }

    public PackageChangeEvent( final Package pkg ) {
        this.pkg = pkg;
    }

    public Package getPackage() {
        return pkg;
    }

}
