/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.security.ProjectResourceType;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Cacheable;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.RuntimeContentResource;

@Portable
public class Project
implements RuntimeContentResource,
Cacheable {
    public static final ProjectResourceType RESOURCE_TYPE = new ProjectResourceType();
    protected Path rootPath;
    protected Path pomXMLPath;
    protected String projectName;
    protected Collection<String> modules = new ArrayList<String>();
    private Collection<String> groups = new ArrayList<String>();
    private boolean requiresRefresh = true;
    private POM pom;

    public Project() {
    }

    public Project(Path rootPath, Path pomXMLPath, String projectName) {
        this.rootPath = (Path)PortablePreconditions.checkNotNull((String)"rootPath", (Object)rootPath);
        this.pomXMLPath = (Path)PortablePreconditions.checkNotNull((String)"pomXMLPath", (Object)pomXMLPath);
        this.projectName = (String)PortablePreconditions.checkNotNull((String)"projectName", (Object)projectName);
    }

    public Project(Path rootPath, Path pomXMLPath, String projectName, Collection<String> modules) {
        this(rootPath, pomXMLPath, projectName);
        this.modules = modules;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public Path getPomXMLPath() {
        return this.pomXMLPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getIdentifier() {
        return this.getRootPath().toURI();
    }

    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    public Collection<String> getGroups() {
        return this.groups;
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public POM getPom() {
        return this.pom;
    }

    public void setPom(POM pom) {
        this.pom = pom;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.rootPath != null ? this.rootPath.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.pomXMLPath != null ? this.pomXMLPath.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.projectName != null ? this.projectName.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.modules != null ? this.modules.hashCode() : 0);
        hash = ~(~hash);
        hash = 17 * hash + (this.groups != null ? this.groups.hashCode() : 0);
        hash = ~(~hash);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        if (!(this.rootPath == other.rootPath || this.rootPath != null && this.rootPath.equals(other.rootPath))) {
            return false;
        }
        if (!(this.pomXMLPath == other.pomXMLPath || this.pomXMLPath != null && this.pomXMLPath.equals(other.pomXMLPath))) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        if (!(this.modules == other.modules || this.modules != null && this.modules.equals(other.modules))) {
            return false;
        }
        return this.groups == other.groups || this.groups != null && this.groups.equals(other.groups);
    }
}

