/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.common.services.project.preferences;

import java.lang.RuntimeException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.annotations.PortablePreference;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.PropertyFormType;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Portable( mapSuperTypes = true )
@PortablePreference
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class GAVPreferencesPortableGeneratedImpl extends GAVPreferences implements BasePreferencePortable<GAVPreferences> {

    public GAVPreferencesPortableGeneratedImpl() {
    }

    public GAVPreferencesPortableGeneratedImpl( @MapsTo("conflictingGAVCheckDisabled") boolean conflictingGAVCheckDisabled, @MapsTo("childGAVEditEnabled") boolean childGAVEditEnabled ) {
        setConflictingGAVCheckDisabled( conflictingGAVCheckDisabled );
        setChildGAVEditEnabled( childGAVEditEnabled );
    }

    @Override
    public Class<GAVPreferences> getPojoClass() {
        return GAVPreferences.class;
    }

    @Override
    public String identifier() {
        return "GAVPreferences";
    }

    @Override
    public String[] parents() {
        return new String[] { "GeneralPreferences" };
    }

    @Override
    public String bundleKey() {
        return "GAVPreferences.Label";
    }

    @Override
    public void set( String property, Object value ) {
        if ( property.equals( "conflictingGAVCheckDisabled" ) ) {
            setConflictingGAVCheckDisabled( (boolean) value );
        } else
        if ( property.equals( "childGAVEditEnabled" ) ) {
            setChildGAVEditEnabled( (boolean) value );
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Object get( String property ) {
        if ( property.equals( "conflictingGAVCheckDisabled" ) ) {
            return isConflictingGAVCheckDisabled();
        } else
        if ( property.equals( "childGAVEditEnabled" ) ) {
            return isChildGAVEditEnabled();
        } else
        {
            throw new RuntimeException( "Unknown property: " + property );
        }
    }

    @Override
    public Map<String, PropertyFormType> getPropertiesTypes() {
        Map<String, PropertyFormType> propertiesTypes = new HashMap<>();

        propertiesTypes.put( "conflictingGAVCheckDisabled", PropertyFormType.BOOLEAN);
        propertiesTypes.put( "childGAVEditEnabled", PropertyFormType.BOOLEAN);

        return propertiesTypes;
    }

    @Override
    public boolean equals( final Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final GAVPreferencesPortableGeneratedImpl that = (GAVPreferencesPortableGeneratedImpl) o;

        if ( isConflictingGAVCheckDisabled() != that.isConflictingGAVCheckDisabled() ) {
            return false;
        }
        if ( isChildGAVEditEnabled() != that.isChildGAVEditEnabled() ) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;

        result = 31 * result + java.lang.Boolean.hashCode( isConflictingGAVCheckDisabled() );
        result = ~~result;
        result = 31 * result + java.lang.Boolean.hashCode( isChildGAVEditEnabled() );
        result = ~~result;

        return result;
    }

    @Override
    public boolean isPersistable() {
        return true;
    }
}
