/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.model;

import java.util.Collection;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DependenciesTest {
    private Dependencies dependencies;
    private Dependency droolsCore;
    private Dependency junit;

    @Before
    public void setUp() throws Exception {
        this.dependencies = new Dependencies();
        this.droolsCore = new Dependency(new GAV("org.drools:drools-core:5.0"));
        this.droolsCore.setScope("compile");
        this.dependencies.add(this.droolsCore);
        this.junit = new Dependency(new GAV("junit:junit:4.11"));
        this.junit.setScope("test");
        this.dependencies.add(this.junit);
    }

    @Test
    public void testGetAllGAVs() throws Exception {
        Collection gavs = this.dependencies.getGavs(new String[0]);
        Assert.assertEquals((long)2L, (long)gavs.size());
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
        DependenciesTest.assertContains(gavs, "junit", "junit", "4.11");
    }

    @Test
    public void testFindByGav() throws Exception {
        Assert.assertEquals((Object)this.droolsCore, (Object)this.dependencies.get(new GAV("org.drools:drools-core:5.0")));
    }

    @Test
    public void testNullWhenNoResults() throws Exception {
        Assert.assertNull((Object)this.dependencies.get(new GAV("org.drools:drools-core:112.0")));
    }

    public static void assertContains(Collection<GAV> gavs, String groupID, String artifactID, String version) {
        for (GAV gav : gavs) {
            if (!gav.getArtifactId().equals(artifactID) || !gav.getGroupId().equals(groupID) || !gav.getVersion().equals(version)) continue;
            return;
        }
        Assert.fail((String)("Could not find " + groupID + ":" + artifactID + ":" + version));
    }

    @Test
    public void testContainsGAV() throws Exception {
        Assert.assertTrue((boolean)this.dependencies.containsDependency(new GAV("org.drools:drools-core:5.0")));
        Dependency dependency = new Dependency(new GAV("org.drools:drools-core:5.0"));
        dependency.setScope("test");
        Assert.assertTrue((boolean)this.dependencies.containsDependency((GAV)dependency));
        Assert.assertFalse((boolean)this.dependencies.containsDependency(new GAV("org.drools:drools-core:4.0")));
    }

    @Test
    public void testGetTestScopedGAVs() throws Exception {
        Collection gavs = this.dependencies.getGavs(new String[]{"test"});
        Assert.assertEquals((long)1L, (long)gavs.size());
        DependenciesTest.assertContains(gavs, "junit", "junit", "4.11");
    }

    @Test
    public void testGetCompileScopedGAVs() throws Exception {
        Collection gavs = this.dependencies.getGavs(new String[]{"compile"});
        Assert.assertEquals((long)1L, (long)gavs.size());
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
    }

    @Test
    public void testGetCompileScopedGavsMethod() throws Exception {
        Collection gavs = this.dependencies.getCompileScopedGavs();
        Assert.assertEquals((long)1L, (long)gavs.size());
        DependenciesTest.assertContains(gavs, "org.drools", "drools-core", "5.0");
    }
}

