/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.lang.annotation.Annotation;
import java.net.URL;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.jboss.weld.environment.se.StartMain;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.file.SimpleFileSystemProvider;

public class ProjectServiceImplResolveTestTests {
    private final SimpleFileSystemProvider fs = new SimpleFileSystemProvider();
    private BeanManager beanManager;
    private Paths paths;

    @Before
    public void setUp() throws Exception {
        StartMain startMain = new StartMain(new String[0]);
        this.beanManager = startMain.go().getBeanManager();
        Bean pathsBean = (Bean)this.beanManager.getBeans(Paths.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)pathsBean);
        this.paths = (Paths)this.beanManager.getReference(pathsBean, Paths.class, cc);
        this.fs.forceAsDefault();
    }

    @Test
    public void testResolveTestPackageWithNonProjectPath() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL testUrl = this.getClass().getResource("/");
        Path testNioPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)testNioPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithRootPath() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithSrcPath() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageWithMainPath() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveTestPackageDefaultJava() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestSrcPath().toURI());
    }

    @Test
    public void testResolveTestPackageDefaultResources() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestResourcesPath().toURI());
    }

    @Test
    public void testResolveTestPackageWithJavaFileInPackage() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/java/org/kie/test/project/backend/BeanTest.java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestSrcPath().toURI());
    }

    @Test
    public void testResolveTestPackageWithResourcesFileInPackage() throws Exception {
        Bean projectServiceBean = (Bean)this.beanManager.getBeans(ProjectService.class, new Annotation[0]).iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)projectServiceBean);
        ProjectService projectService = (ProjectService)this.beanManager.getReference(projectServiceBean, ProjectService.class, cc);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/test/resources/org/kie/test/project/backend/test.scenario");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageTestResourcesPath().toURI());
    }
}

