/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import org.drools.workbench.models.datamodel.imports.Import;
import org.guvnor.common.services.project.backend.server.ProjectConfigurationContentHandler;
import org.guvnor.common.services.project.model.ProjectImports;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectConfigurationContentHandlerTest {
    private ProjectConfigurationContentHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new ProjectConfigurationContentHandler();
    }

    @Test
    public void testVersion() throws Exception {
        Assert.assertTrue((boolean)this.handler.toString(new ProjectImports()).contains("<version>1.0</version>"));
    }

    @Test
    public void testNullSourceXml() throws Exception {
        ProjectImports imports = this.handler.toModel(null);
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)0L, (long)imports.getImports().getImports().size());
    }

    @Test
    public void testEmptySourceXml() throws Exception {
        ProjectImports imports = this.handler.toModel("");
        Assert.assertNotNull((Object)imports);
        Assert.assertEquals((long)0L, (long)imports.getImports().getImports().size());
    }

    @Test
    public void testNullModel() throws Exception {
        String xml = this.handler.toString(null);
        Assert.assertEquals((Object)"", (Object)xml);
    }

    @Test
    public void testEmptyImports() throws Exception {
        String xml = this.handler.toString(new ProjectImports());
        Assert.assertTrue((boolean)xml.contains("<imports>"));
        Assert.assertTrue((boolean)xml.contains("</imports>"));
    }

    @Test
    public void testImports() throws Exception {
        ProjectImports configuration = new ProjectImports();
        configuration.getImports().addImport(new Import("java.util.List"));
        configuration.getImports().addImport(new Import("org.test.Object"));
        String xml = this.handler.toString(configuration);
        Assert.assertTrue((boolean)xml.contains("<import>"));
        Assert.assertTrue((boolean)xml.contains("</import>"));
        Assert.assertTrue((boolean)xml.contains("<type>java.util.List</type>"));
        Assert.assertTrue((boolean)xml.contains("<type>org.test.Object</type>"));
    }
}

