/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.net.URL;
import org.guvnor.common.services.project.backend.server.ProjectServiceImplBaseTest;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.ProjectService;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

public class ProjectServiceImplResolveSrcTests
extends ProjectServiceImplBaseTest {
    @Test
    public void testResolveSrcPackageWithNonProjectPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL testUrl = this.getClass().getResource("/");
        Path testNioPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)testNioPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveSrcPackageWithRootPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveSrcPackageWithSrcPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveSrcPackageWithMainPath() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        Package result = projectService.resolvePackage(rootPath);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testResolveSrcPackageDefaultJava() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/java");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageMainSrcPath().toURI());
    }

    @Test
    public void testResolveSrcPackageDefaultResources() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/resources");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/resources");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageMainResourcesPath().toURI());
    }

    @Test
    public void testResolveSrcPackageWithJavaFileInPackage() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/java/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/java/org/kie/test/project/backend/Bean.java");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageMainSrcPath().toURI());
    }

    @Test
    public void testResolveSrcPackageWithResourcesFileInPackage() throws Exception {
        ProjectService projectService = this.getService(ProjectService.class);
        URL rootUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/resources/org/kie/test/project/backend");
        Path nioRootPath = this.fs.getPath(rootUrl.toURI());
        org.uberfire.backend.vfs.Path rootPath = Paths.convert((Path)nioRootPath);
        URL testUrl = this.getClass().getResource("/ProjectBackendTestProject1/src/main/resources/org/kie/test/project/backend/rule1.drl");
        Path nioTestPath = this.fs.getPath(testUrl.toURI());
        org.uberfire.backend.vfs.Path testPath = Paths.convert((Path)nioTestPath);
        Package result = projectService.resolvePackage(testPath);
        Assert.assertEquals((Object)rootPath.toURI(), (Object)result.getPackageMainResourcesPath().toURI());
    }
}

