/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.project.backend.server.POMContentHandler;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.junit.Assert;
import org.junit.Test;

public class POMContentHandlerTest {
    private static final String GAV_GROUP_ID_XML = "<groupId>org.guvnor</groupId>";
    private static final String GAV_ARTIFACT_ID_XML = "<artifactId>test</artifactId>";
    private static final String GAV_VERSION_XML = "<version>0.0.1</version>";
    private static final String PLUGIN_XML = "<plugin><groupId>org.kie</groupId><artifactId>kie-maven-plugin</artifactId><version>" + POMContentHandler.getKiePluginVersion() + "</version>" + "<extensions>true</extensions>" + "</plugin>";
    private static final String EXISTING_PLUGIN_XML = "<plugin><groupId>org.kie</groupId><artifactId>kie-maven-plugin</artifactId><version>another-version</version><extensions>true</extensions></plugin>";

    @Test
    public void testPOMContentHandlerNewProject() throws IOException {
        POMContentHandler handler = new POMContentHandler();
        GAV gav = new GAV();
        gav.setGroupId("org.guvnor");
        gav.setArtifactId("test");
        gav.setVersion("0.0.1");
        POM pom = new POM("name", "description", gav);
        String xml = handler.toString(pom);
        this.assertContainsIgnoreWhitespace(GAV_GROUP_ID_XML, xml);
        this.assertContainsIgnoreWhitespace(GAV_ARTIFACT_ID_XML, xml);
        this.assertContainsIgnoreWhitespace(GAV_VERSION_XML, xml);
        this.assertContainsIgnoreWhitespace(PLUGIN_XML, xml);
    }

    @Test
    public void testPOMContentHandlerExistingProject() throws IOException, XmlPullParserException {
        POMContentHandler handler = new POMContentHandler();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description></project>";
        POM pom = handler.toModel("<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description></project>");
        Assert.assertEquals((Object)"org.guvnor", (Object)pom.getGav().getGroupId());
        Assert.assertEquals((Object)"test", (Object)pom.getGav().getArtifactId());
        Assert.assertEquals((Object)"0.0.1", (Object)pom.getGav().getVersion());
        Assert.assertEquals((Object)"name", (Object)pom.getName());
        Assert.assertEquals((Object)"description", (Object)pom.getDescription());
        String enrichedXml = handler.toString(pom, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description></project>");
        this.assertContainsIgnoreWhitespace(GAV_GROUP_ID_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(GAV_ARTIFACT_ID_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(GAV_VERSION_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(PLUGIN_XML, enrichedXml);
    }

    @Test
    public void testPOMContentHandlerExistingJarProject() throws IOException, XmlPullParserException {
        POMContentHandler handler = new POMContentHandler();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><packaging>something</packaging><name>name</name><description>description</description></project>";
        String enrichedXml = handler.toString(handler.toModel("<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><packaging>something</packaging><name>name</name><description>description</description></project>"), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><packaging>something</packaging><name>name</name><description>description</description></project>");
        this.assertContainsIgnoreWhitespace("<packaging>something</packaging>", enrichedXml);
    }

    @Test
    public void testPOMContentHandlerExistingKieProject() throws IOException, XmlPullParserException {
        POMContentHandler handler = new POMContentHandler();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description><build><plugins><plugin><groupId>org.kie</groupId><artifactId>kie-maven-plugin</artifactId><version>another-version</version><extensions>true</extensions></plugin></plugins></build></project>";
        POM pom = handler.toModel("<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description><build><plugins><plugin><groupId>org.kie</groupId><artifactId>kie-maven-plugin</artifactId><version>another-version</version><extensions>true</extensions></plugin></plugins></build></project>");
        Assert.assertEquals((Object)"org.guvnor", (Object)pom.getGav().getGroupId());
        Assert.assertEquals((Object)"test", (Object)pom.getGav().getArtifactId());
        Assert.assertEquals((Object)"0.0.1", (Object)pom.getGav().getVersion());
        Assert.assertEquals((Object)"name", (Object)pom.getName());
        Assert.assertEquals((Object)"description", (Object)pom.getDescription());
        String enrichedXml = handler.toString(pom, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><modelVersion>4.0.0</modelVersion><groupId>org.guvnor</groupId><artifactId>test</artifactId><version>0.0.1</version><name>name</name><description>description</description><build><plugins><plugin><groupId>org.kie</groupId><artifactId>kie-maven-plugin</artifactId><version>another-version</version><extensions>true</extensions></plugin></plugins></build></project>");
        this.assertContainsIgnoreWhitespace(GAV_GROUP_ID_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(GAV_ARTIFACT_ID_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(GAV_VERSION_XML, enrichedXml);
        this.assertContainsIgnoreWhitespace(EXISTING_PLUGIN_XML, enrichedXml);
    }

    @Test
    public void testParent() throws Exception {
        POMContentHandler handler = new POMContentHandler();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <modelVersion>4.0.0</modelVersion>  <parent>    <groupId>org.tadaa</groupId>    <artifactId>tadaa</artifactId>    <version>1.2.3</version>  </parent>  <artifactId>myproject</artifactId>  <packaging>kjar</packaging>  <name>myproject</name>  <build>    <plugins>      <plugin>        <groupId>org.kie</groupId>        <artifactId>kie-maven-plugin</artifactId>        <version>6.2.0-SNAPSHOT</version>        <extensions>true</extensions>      </plugin>    </plugins>  </build></project>";
        POM pom = handler.toModel("<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <modelVersion>4.0.0</modelVersion>  <parent>    <groupId>org.tadaa</groupId>    <artifactId>tadaa</artifactId>    <version>1.2.3</version>  </parent>  <artifactId>myproject</artifactId>  <packaging>kjar</packaging>  <name>myproject</name>  <build>    <plugins>      <plugin>        <groupId>org.kie</groupId>        <artifactId>kie-maven-plugin</artifactId>        <version>6.2.0-SNAPSHOT</version>        <extensions>true</extensions>      </plugin>    </plugins>  </build></project>");
        Assert.assertNotNull((Object)pom.getParent());
        Assert.assertEquals((Object)"org.tadaa", (Object)pom.getParent().getGroupId());
        Assert.assertEquals((Object)"tadaa", (Object)pom.getParent().getArtifactId());
        Assert.assertEquals((Object)"1.2.3", (Object)pom.getParent().getVersion());
    }

    private void assertContainsIgnoreWhitespace(String expected, String xml) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = xml.replaceAll("\\s+", "");
        Assert.assertTrue((boolean)cleanActual.contains(cleanExpected));
    }
}

