/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.Map;
import org.guvnor.common.services.project.backend.server.GAVCheckPreferencesLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GAVCheckPreferencesLoaderTest {
    private String oldPropertyValue;
    private GAVCheckPreferencesLoader loader;

    @Before
    public void setup() {
        this.oldPropertyValue = System.getProperty("org.guvnor.project.gav.check.disabled");
        this.loader = new GAVCheckPreferencesLoader();
    }

    @After
    public void reset() {
        if (this.oldPropertyValue != null) {
            System.setProperty("org.guvnor.project.gav.check.disabled", this.oldPropertyValue);
        } else {
            System.clearProperty("org.guvnor.project.gav.check.disabled");
        }
    }

    @Test
    public void testWithoutSystemProperty() {
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testWithSystemPropertyTrue() {
        System.setProperty("org.guvnor.project.gav.check.disabled", "true");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)Boolean.parseBoolean((String)results.get("org.guvnor.project.gav.check.disabled")));
    }

    @Test
    public void testWithSystemPropertyFalse() {
        System.setProperty("org.guvnor.project.gav.check.disabled", "false");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertFalse((boolean)Boolean.parseBoolean((String)results.get("org.guvnor.project.gav.check.disabled")));
    }

    @Test
    public void testWithSystemPropertyDuffValue() {
        System.setProperty("org.guvnor.project.gav.check.disabled", "cheese");
        Map results = this.loader.load();
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertFalse((boolean)Boolean.parseBoolean((String)results.get("org.guvnor.project.gav.check.disabled")));
    }
}

