/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.test.GuvnorTestAppSetup;
import org.guvnor.test.TestFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class POMServiceImplCreateTest {
    private POMService service;
    private TestFileSystem testFileSystem;
    private IOService ioService;

    @Before
    public void setUp() throws Exception {
        GuvnorTestAppSetup.ioService = this.ioService = (IOService)Mockito.mock(IOService.class);
        this.testFileSystem = new TestFileSystem();
        this.service = (POMService)this.testFileSystem.getReference(POMService.class);
    }

    @After
    public void tearDown() throws Exception {
        this.testFileSystem.tearDown();
        GuvnorTestAppSetup.reset();
    }

    @Test
    public void testCreate() throws Exception {
        org.uberfire.backend.vfs.Path path = this.testFileSystem.createTempDirectory("/MyTestProject");
        this.service.create(path, "baseurl?", new POM());
        ArgumentCaptor pathArgumentCaptor = ArgumentCaptor.forClass(Path.class);
        ArgumentCaptor stringArgumentCaptor = ArgumentCaptor.forClass(String.class);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)pathArgumentCaptor.capture(), (String)stringArgumentCaptor.capture(), new OpenOption[0]);
        Assert.assertEquals((Object)((Path)pathArgumentCaptor.getValue()).toUri().toString(), (Object)(path.toURI() + "/pom.xml"));
        String pomXML = (String)stringArgumentCaptor.getValue();
        Assert.assertTrue((boolean)pomXML.contains("<id>guvnor-m2-repo</id>"));
    }
}

