/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.file.LinkedDirectoryFilter;
import org.guvnor.common.services.backend.file.LinkedDotFileFilter;
import org.guvnor.common.services.backend.file.LinkedFilter;
import org.guvnor.common.services.backend.file.LinkedMetaInfFolderFilter;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ProjectResourcePaths;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.PackageAlreadyExistsException;
import org.guvnor.common.services.project.service.ProjectResourceResolver;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

public abstract class ResourceResolver<T extends Project>
implements ProjectResourceResolver<T> {
    protected IOService ioService;
    protected POMService pomService;
    protected ConfigurationService configurationService;
    protected CommentedOptionFactory commentedOptionFactory;
    protected BackwardCompatibleUtil backward;

    public ResourceResolver() {
    }

    public ResourceResolver(IOService ioService, POMService pomService, ConfigurationService configurationService, CommentedOptionFactory commentedOptionFactory, BackwardCompatibleUtil backward) {
        this.ioService = ioService;
        this.pomService = pomService;
        this.configurationService = configurationService;
        this.commentedOptionFactory = commentedOptionFactory;
        this.backward = backward;
    }

    public Package newPackage(Package parentPackage, String packageName, boolean startBatch) {
        String newPackageName = packageName.toLowerCase();
        if (newPackageName.contains(".")) {
            newPackageName = newPackageName.replace(".", "/");
        }
        org.uberfire.backend.vfs.Path mainSrcPath = parentPackage.getPackageMainSrcPath();
        org.uberfire.backend.vfs.Path testSrcPath = parentPackage.getPackageTestSrcPath();
        org.uberfire.backend.vfs.Path mainResourcesPath = parentPackage.getPackageMainResourcesPath();
        org.uberfire.backend.vfs.Path testResourcesPath = parentPackage.getPackageTestResourcesPath();
        org.uberfire.backend.vfs.Path pkgPath = null;
        FileSystem fs = Paths.convert((org.uberfire.backend.vfs.Path)parentPackage.getPackageMainSrcPath()).getFileSystem();
        try {
            Package newPackage;
            Path nioTestResourcesPackagePath;
            Path nioMainResourcesPackagePath;
            Path nioTestSrcPackagePath;
            Path nioMainSrcPackagePath;
            if (startBatch) {
                this.ioService.startBatch(fs, new Option[]{this.commentedOptionFactory.makeCommentedOption("New package [" + packageName + "]")});
            }
            if (!Files.exists((Path)(nioMainSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainSrcPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioTestSrcPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testSrcPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestSrcPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioMainResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)mainResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioMainResourcesPackagePath, new FileAttribute[0]));
            }
            if (!Files.exists((Path)(nioTestResourcesPackagePath = Paths.convert((org.uberfire.backend.vfs.Path)testResourcesPath).resolve(newPackageName)), (LinkOption[])new LinkOption[0])) {
                pkgPath = Paths.convert((Path)this.ioService.createDirectory(nioTestResourcesPackagePath, new FileAttribute[0]));
            }
            if (pkgPath == null) {
                throw new PackageAlreadyExistsException(packageName);
            }
            Package package_ = newPackage = this.resolvePackage(pkgPath);
            return package_;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            if (startBatch) {
                this.ioService.endBatch();
            }
        }
    }

    private String getPackagePathSuffix(Path nioProjectRootPath, Path nioPackagePath) {
        Path nioMainSrcPath = nioProjectRootPath.resolve("src/main/java");
        Path nioTestSrcPath = nioProjectRootPath.resolve("src/test/java");
        Path nioMainResourcesPath = nioProjectRootPath.resolve("src/main/resources");
        Path nioTestResourcesPath = nioProjectRootPath.resolve("src/test/resources");
        String packageName = null;
        Path packagePath = null;
        if (nioPackagePath.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        } else if (nioPackagePath.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioPackagePath);
            packageName = packagePath.toString();
        }
        return packageName;
    }

    public abstract T resolveProject(org.uberfire.backend.vfs.Path var1);

    public Project resolveParentProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            if (this.hasPom(path)) {
                org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)path);
                return new Project(projectRootPath, Paths.convert((Path)path.resolve("pom.xml")), projectRootPath.getFileName());
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Project resolveToParentProject(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path parentPomPath = path.resolve("pom.xml");
            if (this.hasPom(path)) {
                POM parent = (POM)this.pomService.load(Paths.convert((Path)parentPomPath));
                org.uberfire.backend.vfs.Path projectRootPath = Paths.convert((Path)path);
                Project project = new Project(projectRootPath, Paths.convert((Path)parentPomPath), projectRootPath.getFileName());
                project.getModules().addAll(parent.getModules());
                return project;
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Set<Package> resolvePackages(Project project) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (project == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : ProjectResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, true, true, true));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : ProjectResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Set<Package> resolvePackages(Package pkg) {
        HashSet<Package> packages = new HashSet<Package>();
        HashSet<String> packageNames = new HashSet<String>();
        if (pkg == null) {
            return packages;
        }
        org.uberfire.backend.vfs.Path projectRoot = pkg.getProjectRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : ProjectResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src).resolve(this.resolvePkgName(pkg.getCaption()));
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, false, true, false));
        }
        HashSet<String> resolvedPackages = new HashSet<String>();
        for (String packagePathSuffix : packageNames) {
            for (String src : ProjectResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                packages.add(this.resolvePackage(Paths.convert((Path)nioPackagePath)));
                resolvedPackages.add(packagePathSuffix);
            }
        }
        return packages;
    }

    public Package resolveDefaultPackage(Project project) {
        HashSet<String> packageNames = new HashSet<String>();
        if (project == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        for (String src : ProjectResourcePaths.SOURCE_PATHS) {
            Path nioPackageRootSrcPath = nioProjectRootPath.resolve(src);
            packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioPackageRootSrcPath, true, true, false));
        }
        HashSet resolvedPackages = new HashSet();
        for (String packagePathSuffix : packageNames) {
            for (String src : ProjectResourcePaths.SOURCE_PATHS) {
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0]) || resolvedPackages.contains(packagePathSuffix)) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    public Package resolveParentPackage(Package pkg) {
        HashSet<String> packageNames = new HashSet<String>();
        Path nioProjectRootPath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getProjectRootPath());
        packageNames.addAll(this.getPackageNames(nioProjectRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainSrcPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioProjectRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageMainResourcesPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioProjectRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageTestSrcPath()).getParent(), true, false, false));
        packageNames.addAll(this.getPackageNames(nioProjectRootPath, Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageTestResourcesPath()).getParent(), true, false, false));
        for (String packagePathSuffix : packageNames) {
            for (String src : ProjectResourcePaths.SOURCE_PATHS) {
                if (packagePathSuffix == null) {
                    return null;
                }
                Path nioPackagePath = nioProjectRootPath.resolve(src).resolve(packagePathSuffix);
                if (!Files.exists((Path)nioPackagePath, (LinkOption[])new LinkOption[0])) continue;
                return this.resolvePackage(Paths.convert((Path)nioPackagePath));
            }
        }
        return null;
    }

    public boolean isPom(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return false;
            }
            T project = this.resolveProject(resource);
            if (project == null) {
                return false;
            }
            Path path = Paths.convert((org.uberfire.backend.vfs.Path)resource).normalize();
            Path pomFilePath = Paths.convert((org.uberfire.backend.vfs.Path)project.getPomXMLPath());
            return path.startsWith(pomFilePath);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public Package resolvePackage(org.uberfire.backend.vfs.Path resource) {
        try {
            if (resource == null) {
                return null;
            }
            T project = this.resolveProject(resource);
            if (project == null) {
                return null;
            }
            if (this.isPom(resource)) {
                return null;
            }
            return this.makePackage((Project)project, resource);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected boolean hasPom(Path path) {
        Path pomPath = path.resolve("pom.xml");
        return Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0]);
    }

    protected T makeProject(Path nioProjectRootPath) {
        T project = this.simpleProjectInstance(nioProjectRootPath);
        this.addSecurityGroups(project);
        return project;
    }

    public abstract T simpleProjectInstance(Path var1);

    protected void addSecurityGroups(T project) {
        ConfigItem groups;
        ConfigGroup projectConfiguration = this.findProjectConfig(project.getRootPath());
        if (projectConfiguration != null && (groups = this.backward.compat(projectConfiguration).getConfigItem("security:groups")) != null) {
            for (String group : (List)groups.getValue()) {
                project.getGroups().add(group);
            }
        }
    }

    protected ConfigGroup findProjectConfig(org.uberfire.backend.vfs.Path projectRoot) {
        List groups = this.configurationService.getConfiguration(ConfigType.PROJECT);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(projectRoot.toURI())) continue;
                return groupConfig;
            }
        }
        return null;
    }

    protected Package makePackage(Project project, org.uberfire.backend.vfs.Path resource) {
        org.uberfire.backend.vfs.Path projectRoot = project.getRootPath();
        Path nioProjectRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
        Path nioMainSrcPath = nioProjectRoot.resolve("src/main/java");
        Path nioTestSrcPath = nioProjectRoot.resolve("src/test/java");
        Path nioMainResourcesPath = nioProjectRoot.resolve("src/main/resources");
        Path nioTestResourcesPath = nioProjectRoot.resolve("src/test/resources");
        Path nioResource = Paths.convert((org.uberfire.backend.vfs.Path)resource);
        if (Files.isRegularFile((Path)nioResource, (LinkOption[])new LinkOption[0])) {
            nioResource = nioResource.getParent();
        }
        String packageName = null;
        Path packagePath = null;
        if (nioResource.startsWith(nioMainSrcPath)) {
            packagePath = nioMainSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestSrcPath)) {
            packagePath = nioTestSrcPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioMainResourcesPath)) {
            packagePath = nioMainResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        } else if (nioResource.startsWith(nioTestResourcesPath)) {
            packagePath = nioTestResourcesPath.relativize(nioResource);
            packageName = packagePath.toString().replaceAll("/", ".");
        }
        if (packageName == null) {
            return null;
        }
        org.uberfire.backend.vfs.Path mainSrcPath = Paths.convert((Path)nioMainSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testSrcPath = Paths.convert((Path)nioTestSrcPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path mainResourcesPath = Paths.convert((Path)nioMainResourcesPath.resolve(packagePath));
        org.uberfire.backend.vfs.Path testResourcesPath = Paths.convert((Path)nioTestResourcesPath.resolve(packagePath));
        String displayName = this.getPackageDisplayName(packageName);
        Package pkg = new Package(project.getRootPath(), mainSrcPath, testSrcPath, mainResourcesPath, testResourcesPath, packageName, displayName, this.getPackageRelativeCaption(displayName, resource.getFileName()));
        return pkg;
    }

    private Set<String> getPackageNames(Path nioProjectRootPath, Path nioPackageSrcPath, boolean includeDefault, boolean includeChild, boolean recursive) {
        HashSet<String> packageNames = new HashSet<String>();
        if (!Files.exists((Path)nioPackageSrcPath, (LinkOption[])new LinkOption[0])) {
            return packageNames;
        }
        if (includeDefault || recursive) {
            packageNames.add(this.getPackagePathSuffix(nioProjectRootPath, nioPackageSrcPath));
        }
        if (!includeChild) {
            return packageNames;
        }
        LinkedMetaInfFolderFilter metaDataFileFilter = new LinkedMetaInfFolderFilter();
        LinkedDotFileFilter dotFileFilter = new LinkedDotFileFilter((LinkedFilter)metaDataFileFilter);
        LinkedDirectoryFilter directoryFilter = new LinkedDirectoryFilter((LinkedFilter)dotFileFilter);
        DirectoryStream nioChildPackageSrcPaths = this.ioService.newDirectoryStream(nioPackageSrcPath, (DirectoryStream.Filter)directoryFilter);
        for (Path nioChildPackageSrcPath : nioChildPackageSrcPaths) {
            if (recursive) {
                packageNames.addAll(this.getPackageNames(nioProjectRootPath, nioChildPackageSrcPath, includeDefault, includeChild, recursive));
                continue;
            }
            packageNames.add(this.getPackagePathSuffix(nioProjectRootPath, nioChildPackageSrcPath));
        }
        return packageNames;
    }

    private String getPackageDisplayName(String packageName) {
        return packageName.isEmpty() ? "<default>" : packageName;
    }

    private String getPackageRelativeCaption(String displayName, String relativeName) {
        return displayName.equals("<default>") ? "<default>" : relativeName;
    }

    private String resolvePkgName(String caption) {
        if (caption.equals("<default>")) {
            return "";
        }
        return caption.replaceAll("\\.", "/");
    }
}

