/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.AbstractProjectRepositoriesServiceImpl;
import org.guvnor.common.services.project.backend.server.ProjectRepositoriesContentHandler;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.guvnor.common.services.project.service.ProjectResourceResolver;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractProjectRepositoriesServiceImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private ProjectRepositoryResolver repositoryResolver;
    @Mock
    private ProjectResourceResolver resourceResolver;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    private ProjectRepositoriesService service;
    private ProjectRepositoriesContentHandler contentHandler;

    @BeforeClass
    public static void setupSystemProperties() {
        System.setProperty("org.uberfire.nio.git.daemon.enabled", "false");
        System.setProperty("org.uberfire.nio.git.ssh.enabled", "false");
        System.setProperty("org.uberfire.sys.repo.monitor.disabled", "true");
    }

    @Before
    public void setup() {
        this.contentHandler = (ProjectRepositoriesContentHandler)Mockito.spy((Object)new ProjectRepositoriesContentHandler());
        this.service = new AbstractProjectRepositoriesServiceImpl<Project>(this.ioService, this.repositoryResolver, this.contentHandler, this.commentedOptionFactory){

            protected Project getProject(org.uberfire.backend.vfs.Path path) {
                return AbstractProjectRepositoriesServiceImplTest.this.resourceResolver.resolveProject(path);
            }
        };
    }

    @Test
    public void testCreateWithoutProject() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData()).thenReturn(metadata);
        Mockito.when((Object)this.resourceResolver.resolveProject(path)).thenReturn(null);
        this.service.create(path);
        ((ProjectResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).resolveProject(path);
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRemoteRepositoriesMetaData();
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class), new Option[]{(Option)Mockito.any(CommentedOption.class)});
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testCreateWithProject() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Project project = (Project)Mockito.mock(Project.class);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData((Project)Mockito.eq((Object)project))).thenReturn(metadata);
        Mockito.when((Object)this.resourceResolver.resolveProject(path)).thenReturn((Object)project);
        this.service.create(path);
        ((ProjectResourceResolver)Mockito.verify((Object)this.resourceResolver, (VerificationMode)Mockito.times((int)1))).resolveProject(path);
        ((ProjectRepositoryResolver)Mockito.verify((Object)this.repositoryResolver, (VerificationMode)Mockito.times((int)1))).getRemoteRepositoriesMetaData((Project)Mockito.eq((Object)project));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class), new Option[]{(Option)Mockito.any(CommentedOption.class)});
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testLoadExisting() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>");
        ProjectRepositories repositories = (ProjectRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)1L, (long)repositories.getRepositories().size());
        ProjectRepositories.ProjectRepository repository = (ProjectRepositories.ProjectRepository)repositories.getRepositories().iterator().next();
        Assert.assertEquals((Object)"id", (Object)repository.getMetadata().getId());
        Assert.assertEquals((Object)"url", (Object)repository.getMetadata().getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)repository.getMetadata().getSource());
        Assert.assertEquals((Object)true, (Object)repository.isIncluded());
        ((ProjectRepositoriesContentHandler)Mockito.verify((Object)this.contentHandler, (VerificationMode)Mockito.times((int)1))).toModel((String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"));
    }

    @Test
    public void testLoadNonExisting() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)false);
        HashSet<MavenRepositoryMetadata> metadata = new HashSet<MavenRepositoryMetadata>();
        metadata.add(new MavenRepositoryMetadata("local", "local-url", MavenRepositorySource.LOCAL));
        Mockito.when((Object)this.repositoryResolver.getRemoteRepositoriesMetaData()).thenReturn(metadata);
        ProjectRepositories repositories = (ProjectRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)1L, (long)repositories.getRepositories().size());
        ProjectRepositories.ProjectRepository repository = (ProjectRepositories.ProjectRepository)repositories.getRepositories().iterator().next();
        Assert.assertEquals((Object)"local", (Object)repository.getMetadata().getId());
        Assert.assertEquals((Object)"local-url", (Object)repository.getMetadata().getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)repository.getMetadata().getSource());
        Assert.assertEquals((Object)true, (Object)repository.isIncluded());
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).startBatch((FileSystem)Mockito.any(FileSystem.class), new Option[]{(Option)Mockito.any(CommentedOption.class)});
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>local</id>\n        <url>local-url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).endBatch();
    }

    @Test
    public void testSave() {
        HashSet<ProjectRepositories.ProjectRepository> repositories = new HashSet<ProjectRepositories.ProjectRepository>();
        repositories.add(new ProjectRepositories.ProjectRepository(true, new MavenRepositoryMetadata("id", "url", MavenRepositorySource.LOCAL)));
        ProjectRepositories projectRepositories = new ProjectRepositories(repositories);
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        this.service.save(path, projectRepositories, "comment");
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Mockito.eq((Object)nioPath), (String)Mockito.eq((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>"), new OpenOption[0]);
    }

    @Test
    public void testFiltered() {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id1</id>\n        <url>url1</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n    <repository>\n      <include>false</include>\n      <metadata>\n        <id>id2</id>\n        <url>url2</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)"default://p0/project.repositories");
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        Mockito.when((Object)this.ioService.exists((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)true);
        Mockito.when((Object)this.ioService.readAllString((Path)Mockito.eq((Object)nioPath))).thenReturn((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id1</id>\n        <url>url1</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n    <repository>\n      <include>false</include>\n      <metadata>\n        <id>id2</id>\n        <url>url2</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>");
        ProjectRepositories repositories = (ProjectRepositories)this.service.load(path);
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)2L, (long)repositories.getRepositories().size());
        MavenRepositoryMetadata[] metadatas = repositories.filterByIncluded();
        Assert.assertEquals((long)1L, (long)metadatas.length);
        MavenRepositoryMetadata metadata = metadatas[0];
        Assert.assertEquals((Object)"id1", (Object)metadata.getId());
        Assert.assertEquals((Object)"url1", (Object)metadata.getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)metadata.getSource());
    }
}

