/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import org.guvnor.common.services.project.backend.server.ProjectRepositoriesContentHandler;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.MavenRepositorySource;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectRepositoriesContentHandlerTest {
    private ProjectRepositoriesContentHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new ProjectRepositoriesContentHandler();
    }

    @Test
    public void testNullSourceXml() throws Exception {
        ProjectRepositories repositories = this.handler.toModel(null);
        Assert.assertNotNull((Object)repositories);
        Assert.assertEquals((long)0L, (long)repositories.getRepositories().size());
    }

    @Test
    public void testEmptySourceXml() throws Exception {
        ProjectRepositories repositories = this.handler.toModel("");
        Assert.assertNotNull((Object)repositories);
        Assert.assertEquals((long)0L, (long)repositories.getRepositories().size());
    }

    @Test
    public void testNullModel() throws Exception {
        String xml = this.handler.toString(null);
        Assert.assertEquals((Object)"", (Object)xml);
    }

    @Test
    public void testEmptyRepositories() throws Exception {
        String xml = this.handler.toString(new ProjectRepositories());
        Assert.assertEquals((Object)"<project-repositories>\n  <repositories/>\n</project-repositories>", (Object)xml);
    }

    @Test
    public void testRepositoriesMarshalling() throws Exception {
        HashSet<ProjectRepositories.ProjectRepository> repositories = new HashSet<ProjectRepositories.ProjectRepository>();
        repositories.add(new ProjectRepositories.ProjectRepository(true, new MavenRepositoryMetadata("id", "url", MavenRepositorySource.LOCAL)));
        ProjectRepositories projectRepositories = new ProjectRepositories(repositories);
        String xml = this.handler.toString(projectRepositories);
        Assert.assertEquals((Object)"<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>", (Object)xml);
    }

    @Test
    public void testRepositoriesUnmarshalling() throws Exception {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>";
        ProjectRepositories repositories = this.handler.toModel("<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <metadata>\n        <id>id</id>\n        <url>url</url>\n        <source>LOCAL</source>\n      </metadata>\n    </repository>\n  </repositories>\n</project-repositories>");
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)1L, (long)repositories.getRepositories().size());
        ProjectRepositories.ProjectRepository repository = (ProjectRepositories.ProjectRepository)repositories.getRepositories().iterator().next();
        Assert.assertEquals((Object)"id", (Object)repository.getMetadata().getId());
        Assert.assertEquals((Object)"url", (Object)repository.getMetadata().getUrl());
        Assert.assertEquals((Object)MavenRepositorySource.LOCAL, (Object)repository.getMetadata().getSource());
        Assert.assertEquals((Object)true, (Object)repository.isIncluded());
    }

    @Test
    public void testRepositoriesUnmarshalling_InvalidXml() throws Exception {
        String xml = "<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <cheese>\n        <name>cheddar</name>\n      </cheese>\n    </repository>\n  </repositories>\n</project-repositories>";
        ProjectRepositories repositories = this.handler.toModel("<project-repositories>\n  <repositories>\n    <repository>\n      <include>true</include>\n      <cheese>\n        <name>cheddar</name>\n      </cheese>\n    </repository>\n  </repositories>\n</project-repositories>");
        Assert.assertNotNull((Object)repositories);
        Assert.assertNotNull((Object)repositories.getRepositories());
        Assert.assertEquals((long)0L, (long)repositories.getRepositories().size());
    }
}

