/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.Aether;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.embedder.MavenSettings;

public class RepositoryResolverTestUtils {
    private static final String REPO_1 = "<repository>\n<id>jboss-origin-repository-group</id>\n<name>JBoss.org Public Repository Group</name>\n<url>https://origin-repository.jboss.org/nexus/content/groups/ea/</url>\n</repository>\n";
    private static final String REPO_2 = "<repository>\n<id>jboss-developer-repository-group</id>\n<name>JBoss.org Developer Repository Group</name>\n<url>https://repository.jboss.org/nexus/content/groups/developer/</url>\n</repository>\n";
    private static final String REPO_3 = "<repository>\n<id>jboss-public-repository-group</id>\n<name>JBoss Public Repository Group</name>\n<url>http://repository.jboss.org/nexus/content/groups/public/</url>\n</repository>\n";
    private static final String PLUGIN_REPO_1 = "<pluginRepository>\n<id>jboss-public-repository-group</id>\n<name>JBoss Public Repository Group</name>\n<url>https://repository.jboss.org/nexus/content/repositories/snapshots/</url>\n</pluginRepository>\n";

    public static void installArtifact(MavenProject mavenProject, String pomXml) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        Aether aether = new Aether(mavenProject);
        MavenRepository mavenRepository = new MavenRepository(aether){};
        mavenRepository.installArtifact((ReleaseId)releaseId, "content".getBytes(), pomXml.getBytes());
    }

    public static void deployArtifact(MavenProject mavenProject, String pomXml) {
        ReleaseIdImpl releaseId = new ReleaseIdImpl(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion());
        Aether aether = new Aether(mavenProject);
        File jarFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".jar");
        try {
            FileOutputStream fos = new FileOutputStream(jarFile);
            fos.write("content".getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File pomFile = new File(System.getProperty("java.io.tmpdir"), MavenRepository.toFileName((ReleaseId)releaseId, null) + ".pom");
        try {
            FileOutputStream fos = new FileOutputStream(pomFile);
            fos.write(pomXml.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DefaultArtifact jarArtifact = new DefaultArtifact(releaseId.getGroupId(), releaseId.getArtifactId(), "jar", releaseId.getVersion());
        jarArtifact = jarArtifact.setFile(jarFile);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, "", "pom");
        pomArtifact = pomArtifact.setFile(pomFile);
        DistributionManagement distributionManagement = mavenProject.getDistributionManagement();
        if (distributionManagement != null) {
            DeployRequest deployRequest = new DeployRequest();
            deployRequest.addArtifact((Artifact)jarArtifact).addArtifact((Artifact)pomArtifact).setRepository(RepositoryResolverTestUtils.getRemoteRepoFromDeployment(distributionManagement.getRepository(), aether.getSession()));
            try {
                aether.getSystem().deploy(aether.getSession(), deployRequest);
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static RemoteRepository getRemoteRepoFromDeployment(DeploymentRepository deploymentRepository, RepositorySystemSession mavenSession) {
        RemoteRepository.Builder remoteRepoBuilder = new RemoteRepository.Builder(deploymentRepository.getId(), deploymentRepository.getLayout(), deploymentRepository.getUrl()).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn"));
        Settings settings = MavenSettings.getSettings();
        Server server = settings.getServer(deploymentRepository.getId());
        if (server != null) {
            Authentication authentication = mavenSession.getAuthenticationSelector().getAuthentication(remoteRepoBuilder.build());
            remoteRepoBuilder.setAuthentication(authentication);
        }
        return remoteRepoBuilder.build();
    }

    public static Path generateSettingsXml(Path m2Folder) throws IOException {
        Path settingsXmlPath = Files.createTempFile(m2Folder, "settings", ".xml", new FileAttribute[0]);
        ArrayList<String> settingsXmlLines = new ArrayList<String>();
        ArrayList<String> additionalRepositories = new ArrayList<String>(){
            {
                this.add(RepositoryResolverTestUtils.REPO_1);
                this.add(RepositoryResolverTestUtils.REPO_2);
                this.add(RepositoryResolverTestUtils.REPO_3);
            }
        };
        settingsXmlLines.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        settingsXmlLines.add("<settings>\n");
        settingsXmlLines.add("  <localRepository>" + m2Folder.toString() + "</localRepository>\n");
        if (additionalRepositories.size() > 0) {
            settingsXmlLines.add("  <profiles>\n");
            settingsXmlLines.add("    <profile>\n");
            settingsXmlLines.add("      <id>standard-extra-repos</id>\n");
            settingsXmlLines.add("      <activation>\n");
            settingsXmlLines.add("        <activeByDefault>true</activeByDefault>\n");
            settingsXmlLines.add("      </activation>\n");
            settingsXmlLines.add("      <repositories>\n");
            settingsXmlLines.addAll(additionalRepositories);
            settingsXmlLines.add("      </repositories>\n");
            settingsXmlLines.add("      <pluginRepositories>\n");
            settingsXmlLines.add(PLUGIN_REPO_1);
            settingsXmlLines.add("        </pluginRepositories>\n");
            settingsXmlLines.add("    </profile>\n");
            settingsXmlLines.add("  </profiles>\n");
        }
        settingsXmlLines.add("</settings>");
        Files.write(settingsXmlPath, settingsXmlLines, StandardCharsets.UTF_8, new OpenOption[0]);
        return settingsXmlPath;
    }
}

