/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ProjectResourcePathResolver;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.server.config.ConfigurationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractResourceResolverTest {
    protected static final int PROJECT_RESOURCE_PATH_RESOLVERS_SIZE = 5;
    @Mock
    protected IOService ioService;
    @Mock
    protected POMService pomService;
    @Mock
    protected ConfigurationService configurationService;
    @Mock
    protected CommentedOptionFactory commentedOptionFactory;
    @Mock
    protected BackwardCompatibleUtil backward;
    @Mock
    protected Instance<ProjectResourcePathResolver> resourcePathResolversInstance;
    protected ResourceResolver resourceResolver;
    protected List<ProjectResourcePathResolver> projectResourcePathResolvers = new ArrayList<ProjectResourcePathResolver>();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        this.initProjectResourcePathResolvers(5);
        Mockito.when((Object)this.resourcePathResolversInstance.iterator()).thenReturn(this.projectResourcePathResolvers.iterator());
        this.resourceResolver = (ResourceResolver)Mockito.spy((Object)new ResourceResolver(this.ioService, this.pomService, this.configurationService, this.commentedOptionFactory, this.backward, this.resourcePathResolversInstance){

            public Project resolveProject(org.uberfire.backend.vfs.Path resource) {
                return null;
            }

            public Project simpleProjectInstance(Path nioProjectRootPath) {
                return null;
            }
        });
    }

    @Test
    public void resolveDefaultPathSuccessful() {
        Package pkg = (Package)Mockito.mock(Package.class);
        String resourceType = "any";
        org.uberfire.backend.vfs.Path defaultPath = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        ProjectResourcePathResolver blessedProjectResourcePathResolver = this.projectResourcePathResolvers.get(3);
        Mockito.when((Object)blessedProjectResourcePathResolver.accept(resourceType)).thenReturn((Object)true);
        Mockito.when((Object)blessedProjectResourcePathResolver.resolveDefaultPath(pkg)).thenReturn((Object)defaultPath);
        Assert.assertEquals((Object)defaultPath, (Object)this.resourceResolver.resolveDefaultPath(pkg, resourceType));
        ((ProjectResourcePathResolver)Mockito.verify((Object)blessedProjectResourcePathResolver, (VerificationMode)Mockito.times((int)1))).resolveDefaultPath(pkg);
        this.projectResourcePathResolvers.forEach(projectResourcePathResolver -> {
            if (projectResourcePathResolver != blessedProjectResourcePathResolver) {
                ((ProjectResourcePathResolver)Mockito.verify((Object)projectResourcePathResolver, (VerificationMode)Mockito.never())).resolveDefaultPath((Package)Mockito.any(Package.class));
            }
        });
    }

    @Test
    public void resolveDefaultPathWithErrors() {
        Package pkg = (Package)Mockito.mock(Package.class);
        String resourceType = "any";
        this.expectedException.expectMessage("No ProjectResourcePathResolver has been defined for resourceType: " + resourceType);
        this.resourceResolver.resolveDefaultPath(pkg, resourceType);
    }

    private void initProjectResourcePathResolvers(int size) {
        for (int i = 0; i < size; ++i) {
            this.projectResourcePathResolvers.add((ProjectResourcePathResolver)Mockito.mock(ProjectResourcePathResolver.class));
        }
    }
}

