/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.utils.POMContentHandler;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Repository;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.cdi.workspace.WorkspaceScoped;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

@Service
@WorkspaceScoped
public class POMServiceImpl
implements POMService {
    private IOService ioService;
    private POMContentHandler pomContentHandler;
    private M2RepoService m2RepoService;
    private MetadataService metadataService;
    @Inject
    private CommentedOptionFactory optionsFactory;

    public POMServiceImpl() {
    }

    @Inject
    public POMServiceImpl(@Named(value="ioStrategy") IOService ioService, POMContentHandler pomContentHandler, M2RepoService m2RepoService, MetadataService metadataService) {
        this.ioService = ioService;
        this.pomContentHandler = pomContentHandler;
        this.m2RepoService = m2RepoService;
        this.metadataService = metadataService;
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path projectRoot, String repositoryWebBaseURL, POM pomModel) {
        Path pathToPOMXML = null;
        try {
            pomModel.addRepository(this.getRepository(repositoryWebBaseURL));
            Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)projectRoot);
            pathToPOMXML = nioRoot.resolve("pom.xml");
            if (this.ioService.exists(pathToPOMXML)) {
                throw new FileAlreadyExistsException(pathToPOMXML.toString());
            }
            this.ioService.write(pathToPOMXML, this.pomContentHandler.toString(pomModel), new OpenOption[0]);
            return Paths.convert((Path)pathToPOMXML);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private Repository getRepository(String baseURL) {
        Repository repository = new Repository();
        repository.setId("guvnor-m2-repo");
        repository.setName("Guvnor M2 Repo");
        repository.setUrl(this.m2RepoService.getRepositoryURL(baseURL));
        return repository;
    }

    public POM load(org.uberfire.backend.vfs.Path path) {
        try {
            return this.pomContentHandler.toModel(this.loadPomXMLString(path));
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private String loadPomXMLString(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return this.ioService.readAllString(nioPath);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment) {
        try {
            return this.save(path, content, metadata);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata, String comment, boolean updateModules) {
        try {
            this.ioService.startBatch(new FileSystem[]{Paths.convert((org.uberfire.backend.vfs.Path)path).getFileSystem()}, new Option[]{this.optionsFactory.makeCommentedOption(comment != null ? comment : "")});
            this.save(path, content, metadata);
            this.saveSubModules(path, content, updateModules);
            org.uberfire.backend.vfs.Path path2 = path;
            return path2;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private void saveSubModules(org.uberfire.backend.vfs.Path path, POM content, boolean updateModules) throws IOException, XmlPullParserException {
        if (updateModules && content.isMultiModule() && content.getModules() != null) {
            for (String module : content.getModules()) {
                POM child;
                Path childPath = Paths.convert((org.uberfire.backend.vfs.Path)path).getParent().resolve(module).resolve("pom.xml");
                if (!this.ioService.exists(childPath) || (child = this.load(Paths.convert((Path)childPath))) == null) continue;
                child.setParent(content.getGav());
                child.getGav().setGroupId(content.getGav().getGroupId());
                child.getGav().setVersion(content.getGav().getVersion());
                this.save(Paths.convert((Path)childPath), child);
            }
        }
    }

    private org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, POM content, Metadata metadata) throws IOException, XmlPullParserException {
        if (metadata == null) {
            this.save(path, content);
        } else {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), this.metadataService.setUpAttributes(path, metadata), new OpenOption[0]);
        }
        return path;
    }

    private void save(org.uberfire.backend.vfs.Path path, POM content) throws IOException, XmlPullParserException {
        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.pomContentHandler.toString(content, this.loadPomXMLString(path)), new OpenOption[0]);
    }
}

