/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.backend.server.ProjectRepositoriesContentHandler;
import org.guvnor.common.services.project.model.MavenRepositoryMetadata;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.model.ProjectRepositories;
import org.guvnor.common.services.project.service.ProjectRepositoriesService;
import org.guvnor.common.services.project.service.ProjectRepositoryResolver;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;

public abstract class AbstractProjectRepositoriesServiceImpl<T extends Project>
implements ProjectRepositoriesService {
    protected IOService ioService;
    protected ProjectRepositoryResolver repositoryResolver;
    protected ProjectRepositoriesContentHandler contentHandler;
    protected CommentedOptionFactory commentedOptionFactory;

    public AbstractProjectRepositoriesServiceImpl() {
    }

    public AbstractProjectRepositoriesServiceImpl(IOService ioService, ProjectRepositoryResolver repositoryResolver, ProjectRepositoriesContentHandler contentHandler, CommentedOptionFactory commentedOptionFactory) {
        this.ioService = ioService;
        this.repositoryResolver = repositoryResolver;
        this.contentHandler = contentHandler;
        this.commentedOptionFactory = commentedOptionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectRepositories create(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(nioPath)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            this.ioService.startBatch(nioPath.getFileSystem(), new Option[]{this.commentedOptionFactory.makeCommentedOption("Creating " + path.toString() + "...")});
            T project = this.getProject(path);
            HashSet<MavenRepositoryMetadata> content = new HashSet<MavenRepositoryMetadata>();
            if (project == null) {
                content.addAll(this.repositoryResolver.getRemoteRepositoriesMetaData());
            } else {
                content.addAll(this.repositoryResolver.getRemoteRepositoriesMetaData(project));
            }
            ProjectRepositories repositories = this.createProjectRepositories(content);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), this.contentHandler.toString(repositories), new OpenOption[0]);
            ProjectRepositories projectRepositories = repositories;
            return projectRepositories;
        }
        finally {
            this.ioService.endBatch();
        }
    }

    private ProjectRepositories createProjectRepositories(Set<MavenRepositoryMetadata> content) {
        HashSet<ProjectRepositories.ProjectRepository> projectRepositories = new HashSet<ProjectRepositories.ProjectRepository>();
        for (MavenRepositoryMetadata md : content) {
            projectRepositories.add(new ProjectRepositories.ProjectRepository(true, md));
        }
        ProjectRepositories repositories = new ProjectRepositories(projectRepositories);
        return repositories;
    }

    public ProjectRepositories load(org.uberfire.backend.vfs.Path path) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(nioPath)) {
            String content = this.ioService.readAllString(nioPath);
            return this.contentHandler.toModel(content);
        }
        return this.create(path);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ProjectRepositories projectRepositories, String comment) {
        try {
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), this.contentHandler.toString(projectRepositories), new OpenOption[0]);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected abstract T getProject(org.uberfire.backend.vfs.Path var1);
}

