/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.datamodel.imports.Import;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.datamodel.oracle.TypeSource;
import org.guvnor.common.services.backend.file.DotFileFilter;
import org.guvnor.common.services.backend.file.JavaFileFilter;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.ProjectImports;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.rulenames.RuleNameUpdateEvent;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.IncrementalResults;
import org.kie.internal.builder.InternalKieBuilder;
import org.kie.scanner.KieModuleMetaData;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;

public class Builder {
    private static final String RESOURCE_PATH = "src/main/resources";
    private static final String ERROR_CLASS_NOT_FOUND = "Class not found";
    private static final String ERROR_EXTERNAL_CLASS_VERIFICATON = "An error was found during external classes check.\nThe external class {0} did not pass the verification. \nPlease check the external .jar files configured as dependencies for this project.\nThe low level error is: ";
    private static final String DEFAULTPKG = "defaultpkg";
    private KieBuilder kieBuilder;
    private final KieServices kieServices;
    private final KieFileSystem kieFileSystem;
    private final Path moduleDirectory;
    private final GAV gav;
    private final IOService ioService;
    private final ProjectService projectService;
    private final String projectPrefix;
    private Map<String, org.uberfire.backend.vfs.Path> handles = new HashMap<String, org.uberfire.backend.vfs.Path>();
    private final Event<RuleNameUpdateEvent> ruleNameUpdateEvent;
    private final List<BuildValidationHelper> buildValidationHelpers;
    private final Map<Path, List<ValidationMessage>> nonKieResourceValidationHelperMessages = new HashMap<Path, List<ValidationMessage>>();
    private final DirectoryStream.Filter<Path> javaResourceFilter = new JavaFileFilter();
    private final DirectoryStream.Filter<Path> dotFileFilter = new DotFileFilter();
    private Set<String> javaResources = new HashSet<String>();
    private KieContainer kieContainer;

    public Builder(Path moduleDirectory, GAV gav, IOService ioService, ProjectService projectService, Event<RuleNameUpdateEvent> ruleNameUpdateEvent, List<BuildValidationHelper> buildValidationHelpers) {
        this.moduleDirectory = moduleDirectory;
        this.gav = gav;
        this.ioService = ioService;
        this.projectService = projectService;
        this.ruleNameUpdateEvent = ruleNameUpdateEvent;
        this.buildValidationHelpers = buildValidationHelpers;
        this.projectPrefix = moduleDirectory.toUri().toString();
        this.kieServices = KieServices.Factory.get();
        this.kieFileSystem = this.kieServices.newKieFileSystem();
        DirectoryStream directoryStream = Files.newDirectoryStream((Path)moduleDirectory);
        this.visitPaths((DirectoryStream<Path>)directoryStream);
    }

    public BuildResults build() {
        Class clazz;
        this.kieBuilder = this.kieServices.newKieBuilder(this.kieFileSystem);
        Results kieResults = this.kieBuilder.buildAll().getResults();
        BuildResults results = this.convertMessages(kieResults);
        for (Map.Entry<Path, List<ValidationMessage>> e : this.nonKieResourceValidationHelperMessages.entrySet()) {
            List<ValidationMessage> validationMessages = e.getValue();
            if (validationMessages == null || validationMessages.isEmpty()) continue;
            for (ValidationMessage validationMessage : validationMessages) {
                results.addBuildMessage(this.convertValidationMessage(validationMessage));
            }
        }
        Path nioExternalImportsPath = this.moduleDirectory.resolve("project.imports");
        if (Files.exists((Path)nioExternalImportsPath, (LinkOption[])new LinkOption[0])) {
            org.uberfire.backend.vfs.Path externalImportsPath = Paths.convert((Path)nioExternalImportsPath);
            ProjectImports projectImports = (ProjectImports)this.projectService.load(externalImportsPath);
            Imports imports = projectImports.getImports();
            for (Import item : imports.getImports()) {
                try {
                    clazz = this.getClass().getClassLoader().loadClass(item.getType());
                }
                catch (ClassNotFoundException cnfe) {
                    results.addBuildMessage(this.makeMessage(ERROR_CLASS_NOT_FOUND, cnfe));
                }
            }
        }
        KieModuleMetaData kieModuleMetaData = this.getKieModuleMetaData();
        for (String packageName : kieModuleMetaData.getPackages()) {
            for (String className : kieModuleMetaData.getClasses(packageName)) {
                clazz = kieModuleMetaData.getClass(packageName, className);
                TypeSource typeSource = this.getClassSource(kieModuleMetaData, clazz);
                if (TypeSource.JAVA_DEPENDENCY != typeSource) continue;
                try {
                    this.verifyExternalClass(clazz);
                }
                catch (Throwable e) {
                    results.addBuildMessage(this.makeMessage(MessageFormat.format(ERROR_EXTERNAL_CLASS_VERIFICATON, clazz.getName()), e));
                }
            }
        }
        if (results.getMessages().isEmpty()) {
            this.kieContainer = this.kieServices.newKieContainer(this.kieBuilder.getKieModule().getReleaseId());
        }
        this.fireRuleNameUpdateEvent();
        return results;
    }

    private KieModuleMetaData getKieModuleMetaData() {
        return KieModuleMetaData.Factory.newKieModuleMetaData((KieModule)((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors());
    }

    private void verifyExternalClass(Class clazz) {
        clazz.getDeclaredConstructors();
        clazz.getDeclaredFields();
        clazz.getDeclaredMethods();
        clazz.getDeclaredClasses();
        clazz.getDeclaredAnnotations();
    }

    public IncrementalBuildResults addResource(Path resource) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) {
            return new IncrementalBuildResults(this.gav);
        }
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null) {
            List<ValidationMessage> removedValidationMessages;
            List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
            if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : addedValidationMessages) {
                    results.addAddedMessage(this.convertValidationMessage(validationMessage));
                }
            }
            if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                for (ValidationMessage validationMessage : removedValidationMessages) {
                    results.addRemovedMessage(this.convertValidationMessage(validationMessage));
                }
            }
            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
        BufferedInputStream bis = new BufferedInputStream(is);
        this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
        this.addJavaClass(resource);
        this.handles.put(destinationPath, Paths.convert((Path)resource));
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        for (Message message : incrementalResults.getAddedMessages()) {
            results.addAddedMessage(this.convertMessage(message));
        }
        for (Message message : incrementalResults.getRemovedMessages()) {
            results.addRemovedMessage(this.convertMessage(message));
        }
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        this.fireRuleNameUpdateEvent();
        return results;
    }

    private void fireRuleNameUpdateEvent() {
        KieModuleMetaData kieModuleMetaData = this.getKieModuleMetaData();
        HashMap<String, Collection> ruleNames = new HashMap<String, Collection>();
        for (String packageName : kieModuleMetaData.getPackages()) {
            if (packageName.isEmpty()) {
                packageName = DEFAULTPKG;
            }
            ruleNames.put(packageName, kieModuleMetaData.getRuleNamesInPackage(packageName));
        }
        ruleNames.put(DEFAULTPKG, kieModuleMetaData.getRuleNamesInPackage(DEFAULTPKG));
        this.ruleNameUpdateEvent.fire((Object)new RuleNameUpdateEvent(ruleNames));
    }

    public IncrementalBuildResults deleteResource(Path resource) {
        List<ValidationMessage> removedValidationMessages;
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
        this.kieFileSystem.delete(new String[]{destinationPath});
        this.removeJavaClass(resource);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(new String[]{destinationPath}).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
        if (validator != null && (removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
            for (ValidationMessage validationMessage : removedValidationMessages) {
                results.addRemovedMessage(this.convertValidationMessage(validationMessage));
            }
        }
        this.fireRuleNameUpdateEvent();
        return results;
    }

    public IncrementalBuildResults updateResource(Path resource) {
        return this.addResource(resource);
    }

    public IncrementalBuildResults applyBatchResourceChanges(Map<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        if (!this.isBuilt()) {
            throw new IllegalStateException("A full build needs to be performed before any incremental operations.");
        }
        ArrayList<String> changedFilesKieBuilderPaths = new ArrayList<String>();
        ArrayList<ValidationMessage> nonKieResourceValidatorAddedMessages = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> nonKieResourceValidatorRemovedMessages = new ArrayList<ValidationMessage>();
        for (Map.Entry<org.uberfire.backend.vfs.Path, Collection<ResourceChange>> pathCollectionEntry : changes.entrySet()) {
            for (ResourceChange change : pathCollectionEntry.getValue()) {
                ResourceChangeType type = change.getType();
                Path resource = Paths.convert((org.uberfire.backend.vfs.Path)pathCollectionEntry.getKey());
                PortablePreconditions.checkNotNull((String)"type", (Object)type);
                PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
                String destinationPath = resource.toUri().toString().substring(this.projectPrefix.length() + 1);
                changedFilesKieBuilderPaths.add(destinationPath);
                switch (type) {
                    case ADD: 
                    case UPDATE: {
                        if (!Files.isRegularFile((Path)resource, (LinkOption[])new LinkOption[0])) break;
                        BuildValidationHelper validator = this.getBuildValidationHelper(resource);
                        if (validator != null) {
                            List<ValidationMessage> removedValidationMessages;
                            List addedValidationMessages = validator.validate(Paths.convert((Path)resource));
                            if (addedValidationMessages != null && !addedValidationMessages.isEmpty()) {
                                for (ValidationMessage validationMessage : addedValidationMessages) {
                                    nonKieResourceValidatorAddedMessages.add(validationMessage);
                                }
                            }
                            if ((removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource)) != null && !removedValidationMessages.isEmpty()) {
                                for (ValidationMessage validationMessage : removedValidationMessages) {
                                    nonKieResourceValidatorRemovedMessages.add(validationMessage);
                                }
                            }
                            this.nonKieResourceValidationHelperMessages.put(resource, addedValidationMessages);
                        }
                        InputStream is = this.ioService.newInputStream(resource, new OpenOption[0]);
                        BufferedInputStream bis = new BufferedInputStream(is);
                        this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
                        this.addJavaClass(resource);
                        this.handles.put(destinationPath, Paths.convert((Path)resource));
                        break;
                    }
                    case DELETE: {
                        this.kieFileSystem.delete(new String[]{destinationPath});
                        this.removeJavaClass(resource);
                        List<ValidationMessage> removedValidationMessages = this.nonKieResourceValidationHelperMessages.remove(resource);
                        if (removedValidationMessages == null || removedValidationMessages.isEmpty()) break;
                        for (ValidationMessage validationMessage : removedValidationMessages) {
                            nonKieResourceValidatorRemovedMessages.add(validationMessage);
                        }
                        break;
                    }
                }
            }
        }
        String[] kieBuilderPaths = new String[changedFilesKieBuilderPaths.size()];
        changedFilesKieBuilderPaths.toArray(kieBuilderPaths);
        IncrementalResults incrementalResults = ((InternalKieBuilder)this.kieBuilder).createFileSet(kieBuilderPaths).build();
        IncrementalBuildResults results = this.convertMessages(incrementalResults);
        for (ValidationMessage addedValidationMessage : nonKieResourceValidatorAddedMessages) {
            results.addAddedMessage(this.convertValidationMessage(addedValidationMessage));
        }
        for (ValidationMessage removedValidationMessage : nonKieResourceValidatorRemovedMessages) {
            results.addRemovedMessage(this.convertValidationMessage(removedValidationMessage));
        }
        for (Message message : incrementalResults.getRemovedMessages()) {
            this.handles.remove("src/main/resources/" + message.getPath());
        }
        return results;
    }

    public KieModule getKieModule() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieBuilder.getKieModule();
    }

    public KieModule getKieModuleIgnoringErrors() {
        if (!this.isBuilt()) {
            this.build();
        }
        return ((InternalKieBuilder)this.kieBuilder).getKieModuleIgnoringErrors();
    }

    public KieContainer getKieContainer() {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.kieContainer;
    }

    public boolean isBuilt() {
        return this.kieBuilder != null;
    }

    private void visitPaths(DirectoryStream<Path> directoryStream) {
        for (Path path : directoryStream) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) {
                this.visitPaths((DirectoryStream<Path>)Files.newDirectoryStream((Path)path));
                continue;
            }
            if (this.dotFileFilter.accept((Object)path)) continue;
            BuildValidationHelper validator = this.getBuildValidationHelper(path);
            if (validator != null) {
                org.uberfire.backend.vfs.Path vfsPath = Paths.convert((Path)path);
                List addedValidationMessages = validator.validate(vfsPath);
                this.nonKieResourceValidationHelperMessages.put(path, addedValidationMessages);
            }
            String destinationPath = path.toUri().toString().substring(this.projectPrefix.length() + 1);
            InputStream is = this.ioService.newInputStream(path, new OpenOption[0]);
            BufferedInputStream bis = new BufferedInputStream(is);
            this.kieFileSystem.write(destinationPath, KieServices.Factory.get().getResources().newInputStreamResource((InputStream)bis));
            this.handles.put(destinationPath, Paths.convert((Path)path));
            this.addJavaClass(path);
        }
    }

    private BuildResults convertMessages(Results kieBuildResults) {
        BuildResults results = new BuildResults(this.gav);
        for (Message message : kieBuildResults.getMessages()) {
            results.addBuildMessage(this.convertMessage(message));
        }
        return results;
    }

    private IncrementalBuildResults convertMessages(IncrementalResults kieIncrementalResults) {
        IncrementalBuildResults results = new IncrementalBuildResults(this.gav);
        for (Message message : kieIncrementalResults.getAddedMessages()) {
            results.addAddedMessage(this.convertMessage(message));
        }
        for (Message message : kieIncrementalResults.getRemovedMessages()) {
            results.addRemovedMessage(this.convertMessage(message));
        }
        return results;
    }

    private BuildMessage convertMessage(Message message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        if (message.getPath() != null && !message.getPath().isEmpty()) {
            m.setPath(this.handles.get("src/main/resources/" + message.getPath()));
        }
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        return m;
    }

    private BuildMessage convertValidationMessage(ValidationMessage message) {
        BuildMessage m = new BuildMessage();
        switch (message.getLevel()) {
            case ERROR: {
                m.setLevel(BuildMessage.Level.ERROR);
                break;
            }
            case WARNING: {
                m.setLevel(BuildMessage.Level.WARNING);
                break;
            }
            case INFO: {
                m.setLevel(BuildMessage.Level.INFO);
            }
        }
        m.setId(message.getId());
        m.setLine(message.getLine());
        m.setColumn(message.getColumn());
        m.setText(message.getText());
        m.setPath(message.getPath());
        return m;
    }

    private BuildMessage makeMessage(String prefix, Throwable e) {
        BuildMessage buildMessage = new BuildMessage();
        buildMessage.setLevel(BuildMessage.Level.ERROR);
        buildMessage.setText(prefix + ": " + e.getMessage());
        return buildMessage;
    }

    private void addJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.add(fullyQualifiedClassName);
        }
    }

    private void removeJavaClass(Path path) {
        if (!this.javaResourceFilter.accept((Object)path)) {
            return;
        }
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(path);
        if (fullyQualifiedClassName != null) {
            this.javaResources.remove(fullyQualifiedClassName);
        }
    }

    private String getFullyQualifiedClassName(Path path) {
        Package pkg = this.projectService.resolvePackage(Paths.convert((Path)path));
        String packageName = pkg.getPackageName();
        if (packageName == null) {
            return null;
        }
        String className = path.getFileName().toString().replace(".java", "");
        return packageName.equals("") ? className : packageName + "." + className;
    }

    public TypeSource getClassSource(KieModuleMetaData metaData, Class<?> clazz) {
        if (metaData.getTypeMetaInfo(clazz).isDeclaredType()) {
            return TypeSource.DECLARED;
        }
        String fullyQualifiedClassName = clazz.getName();
        int innerClassIdentifierIndex = fullyQualifiedClassName.indexOf("$");
        if (innerClassIdentifierIndex > 0) {
            fullyQualifiedClassName = fullyQualifiedClassName.substring(0, innerClassIdentifierIndex);
        }
        if (this.javaResources.contains(fullyQualifiedClassName)) {
            return TypeSource.JAVA_PROJECT;
        }
        return TypeSource.JAVA_DEPENDENCY;
    }

    private BuildValidationHelper getBuildValidationHelper(Path nioResource) {
        for (BuildValidationHelper validator : this.buildValidationHelpers) {
            org.uberfire.backend.vfs.Path resource;
            if (!validator.accepts(resource = Paths.convert((Path)nioResource))) continue;
            return validator;
        }
        return null;
    }
}

