/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.builder.ResourceChangeIncrementalBuilder;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceChange;
import org.uberfire.workbench.events.ResourceChangeType;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@ApplicationScoped
public class ResourceChangeObserver {
    private static final Logger logger = LoggerFactory.getLogger(ResourceChangeObserver.class);
    @Inject
    private ProjectService projectService;
    @Inject
    private ResourceChangeIncrementalBuilder incrementalBuilder;
    @Inject
    private Event<InvalidateDMOProjectCacheEvent> invalidateDMOProjectCacheEvent;

    public void processResourceAdd(@Observes ResourceAddedEvent resourceAddedEvent) {
        this.processResourceChange(resourceAddedEvent.getSessionInfo(), resourceAddedEvent.getPath(), ResourceChangeType.ADD);
        this.incrementalBuilder.addResource(resourceAddedEvent.getPath());
    }

    public void processResourceDelete(@Observes ResourceDeletedEvent resourceDeletedEvent) {
        this.processResourceChange(resourceDeletedEvent.getSessionInfo(), resourceDeletedEvent.getPath(), ResourceChangeType.DELETE);
        this.incrementalBuilder.deleteResource(resourceDeletedEvent.getPath());
    }

    public void processResourceUpdate(@Observes ResourceUpdatedEvent resourceUpdatedEvent) {
        this.processResourceChange(resourceUpdatedEvent.getSessionInfo(), resourceUpdatedEvent.getPath(), ResourceChangeType.UPDATE);
        this.incrementalBuilder.updateResource(resourceUpdatedEvent.getPath());
    }

    public void processBatchChanges(@Observes ResourceBatchChangesEvent resourceBatchChangesEvent) {
        Map batchChanges = resourceBatchChangesEvent.getBatch();
        HashMap<String, Boolean> notifiedProjects = new HashMap<String, Boolean>();
        if (batchChanges == null) {
            logger.warn("No batchChanges was present for the given resourceBatchChangesEvent: " + resourceBatchChangesEvent);
        }
        for (Map.Entry pathCollectionEntry : batchChanges.entrySet()) {
            for (ResourceChange change : (Collection)pathCollectionEntry.getValue()) {
                this.processResourceChange(resourceBatchChangesEvent.getSessionInfo(), (Path)pathCollectionEntry.getKey(), change.getType(), notifiedProjects);
            }
        }
        this.incrementalBuilder.batchResourceChanges(resourceBatchChangesEvent.getBatch());
    }

    private void processResourceChange(SessionInfo sessionInfo, Path path, ResourceChangeType changeType) {
        this.processResourceChange(sessionInfo, path, changeType, new HashMap<String, Boolean>());
    }

    private void processResourceChange(SessionInfo sessionInfo, Path path, ResourceChangeType changeType, Map<String, Boolean> notifiedProjects) {
        Project project = this.projectService.resolveProject(path);
        if (project == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processing resource change for sessionInfo: " + sessionInfo + ", project: " + project + ", path: " + path + ", changeType: " + changeType);
        }
        if (!notifiedProjects.containsKey(project.getRootPath().toURI()) && this.isObservableResource(path)) {
            this.invalidateDMOProjectCacheEvent.fire((Object)new InvalidateDMOProjectCacheEvent(sessionInfo, project, path));
            notifiedProjects.put(project.getRootPath().toURI(), Boolean.TRUE);
        }
    }

    private boolean isObservableResource(Path path) {
        return path != null && (path.getFileName().endsWith(".java") || path.getFileName().endsWith(".class") || path.getFileName().equals("pom.xml") || path.getFileName().equals("kmodule.xml") || path.getFileName().endsWith(".drl") || path.getFileName().endsWith(".gdst") || path.getFileName().endsWith(".rdrl"));
    }
}

