/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.builder.Builder;
import org.guvnor.common.services.builder.LRUBuilderCache;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.builder.service.PostBuildHandler;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.m2repo.backend.server.ExtendedM2RepoService;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private static final Logger logger = LoggerFactory.getLogger(BuildServiceImpl.class);
    private POMService pomService;
    private ExtendedM2RepoService m2RepoService;
    private ProjectService projectService;
    private LRUBuilderCache cache;
    private Instance<PostBuildHandler> handlers;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(POMService pomService, ExtendedM2RepoService m2RepoService, ProjectService projectService, LRUBuilderCache cache, Instance<PostBuildHandler> handlers) {
        this.pomService = pomService;
        this.m2RepoService = m2RepoService;
        this.projectService = projectService;
        this.cache = cache;
        this.handlers = handlers;
    }

    public BuildResults build(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildExceptionResults(e);
        }
    }

    public BuildResults buildAndDeploy(Project project) {
        try {
            BuildResults results = this.doBuild(project);
            POM pom = (POM)this.pomService.load(project.getPomXMLPath());
            if (results.getErrorMessages().isEmpty()) {
                Builder builder = this.cache.assertBuilder(project);
                InternalKieModule kieModule = (InternalKieModule)builder.getKieModule();
                ByteArrayInputStream input = new ByteArrayInputStream(kieModule.getBytes());
                this.m2RepoService.deployJar((InputStream)input, pom.getGav());
                for (PostBuildHandler handler : this.handlers) {
                    try {
                        handler.process(results);
                    }
                    catch (Exception e) {
                        logger.warn("PostBuildHandler {} failed due to {}", (Object)handler, (Object)e.getMessage());
                    }
                }
            }
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.buildExceptionResults(e);
        }
    }

    private BuildResults buildExceptionResults(Exception e) {
        BuildResults exceptionResults = new BuildResults();
        BuildMessage exceptionMessage = new BuildMessage();
        exceptionMessage.setLevel(BuildMessage.Level.ERROR);
        exceptionMessage.setText(e.getMessage());
        exceptionResults.addBuildMessage(exceptionMessage);
        return exceptionResults;
    }

    private BuildResults doBuild(Project project) {
        this.cache.invalidateCache(project);
        Builder builder = this.cache.assertBuilder(project);
        BuildResults results = builder.build();
        return results;
    }

    public boolean isBuilt(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        return builder.isBuilt();
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.addResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.deleteResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        try {
            IncrementalBuildResults results = new IncrementalBuildResults();
            Project project = this.projectService.resolveProject(resource);
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.updateResource(Paths.convert((Path)resource));
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Map<Path, Collection<ResourceChange>> changes) {
        IncrementalBuildResults results = new IncrementalBuildResults();
        try {
            if (project == null) {
                return results;
            }
            Builder builder = this.cache.assertBuilder(project);
            if (!builder.isBuilt()) {
                throw new IllegalStateException("Incremental Build requires a full build be completed first.");
            }
            results = builder.applyBatchResourceChanges(changes);
            return results;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }
}

