/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.builder.AsyncIncrementalBuilder;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManager;
import org.guvnor.common.services.builder.IncrementalBuilderExecutorManagerFactory;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.workbench.events.ResourceChange;

@ApplicationScoped
public class ResourceChangeIncrementalBuilder {
    private static final String INCREMENTAL_BUILD_PROPERTY_NAME = "build.enable-incremental";
    private static final Logger logger = LoggerFactory.getLogger(ResourceChangeIncrementalBuilder.class);
    @Inject
    private ProjectService projectService;
    @Inject
    private AppConfigService appConfigService;
    @Inject
    private IncrementalBuilderExecutorManagerFactory executorManagerProducer;
    private IncrementalBuilderExecutorManager executorManager = null;
    private boolean isIncrementalEnabled = false;

    @PostConstruct
    private void setup() {
        this.isIncrementalEnabled = this.isIncrementalBuildEnabled();
    }

    public void configureOnEvent(@Observes ApplicationStarted applicationStartedEvent) {
        this.isIncrementalEnabled = this.isIncrementalBuildEnabled();
        this.getExecutor();
    }

    private boolean isIncrementalBuildEnabled() {
        String value = (String)this.appConfigService.loadPreferences().get(INCREMENTAL_BUILD_PROPERTY_NAME);
        return Boolean.parseBoolean(value);
    }

    @PreDestroy
    private void destroyExecutorService() {
        if (this.executorManager != null && !this.isEjb(this.executorManager, IncrementalBuilderExecutorManager.class)) {
            this.executorManager.shutdown();
        }
    }

    private boolean isEjb(Object o, Class<?> expected) {
        return o.getClass() != expected;
    }

    private synchronized IncrementalBuilderExecutorManager getExecutor() {
        if (this.executorManager == null) {
            this.executorManager = this.executorManagerProducer.getExecutorManager();
        }
        return this.executorManager;
    }

    public void addResource(final Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (added).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.getExecutor().execute(new AsyncIncrementalBuilder(){

            @Override
            public void execute(ProjectService projectService, BuildService buildService, Event<IncrementalBuildResults> incrementalBuildResultsEvent, Event<BuildResults> buildResultsEvent) {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (added).");
                    Project project = projectService.resolveProject(resource);
                    if (buildService.isBuilt(project)) {
                        IncrementalBuildResults results = buildService.addPackageResource(resource);
                        incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = buildService.build(project);
                        buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public String getDescription() {
                return "Incremental Build [" + resource.toURI() + " (added)]";
            }
        });
    }

    public void deleteResource(final Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (deleted).");
        Package pkg = this.projectService.resolvePackage(resource);
        if (pkg == null) {
            return;
        }
        this.getExecutor().execute(new AsyncIncrementalBuilder(){

            @Override
            public void execute(ProjectService projectService, BuildService buildService, Event<IncrementalBuildResults> incrementalBuildResultsEvent, Event<BuildResults> buildResultsEvent) {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (deleted).");
                    Project project = projectService.resolveProject(resource);
                    if (buildService.isBuilt(project)) {
                        IncrementalBuildResults results = buildService.deletePackageResource(resource);
                        incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = buildService.build(project);
                        buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public String getDescription() {
                return "Incremental Build [" + resource.toURI() + " (deleted)]";
            }
        });
    }

    public void updateResource(Path resource) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Incremental build request received for: " + resource.toURI() + " (updated).");
        boolean isPomFile = this.projectService.isPom(resource);
        boolean isKModuleFile = this.projectService.isKModule(resource);
        if (isPomFile || isKModuleFile) {
            this.scheduleProjectResourceUpdate(resource);
        } else {
            Package pkg = this.projectService.resolvePackage(resource);
            if (pkg == null) {
                return;
            }
            this.schedulePackageResourceUpdate(resource);
        }
    }

    private void scheduleProjectResourceUpdate(final Path resource) {
        final Project project = this.projectService.resolveProject(resource);
        this.getExecutor().execute(new AsyncIncrementalBuilder(){

            @Override
            public void execute(ProjectService projectService, BuildService buildService, Event<IncrementalBuildResults> incrementalBuildResultsEvent, Event<BuildResults> buildResultsEvent) {
                try {
                    logger.info("Incremental build request being processed: " + project.getRootPath() + " (updated).");
                    BuildResults results = buildService.build(project);
                    buildResultsEvent.fire((Object)results);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public String getDescription() {
                return "Incremental Build [" + resource.toURI() + " (updated)]";
            }
        });
    }

    private void schedulePackageResourceUpdate(final Path resource) {
        this.getExecutor().execute(new AsyncIncrementalBuilder(){

            @Override
            public void execute(ProjectService projectService, BuildService buildService, Event<IncrementalBuildResults> incrementalBuildResultsEvent, Event<BuildResults> buildResultsEvent) {
                try {
                    logger.info("Incremental build request being processed: " + resource.toURI() + " (updated).");
                    Project project = projectService.resolveProject(resource);
                    if (buildService.isBuilt(project)) {
                        IncrementalBuildResults results = buildService.updatePackageResource(resource);
                        incrementalBuildResultsEvent.fire((Object)results);
                    } else {
                        BuildResults results = buildService.build(project);
                        buildResultsEvent.fire((Object)results);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public String getDescription() {
                return "Incremental Build [" + resource.toURI() + " (updated)]";
            }
        });
    }

    public void batchResourceChanges(Map<Path, Collection<ResourceChange>> batch) {
        if (!this.isIncrementalEnabled) {
            return;
        }
        logger.info("Batch incremental build request received.");
        HashMap projectBatchChanges = new HashMap();
        for (Map.Entry<Path, Collection<ResourceChange>> entry : batch.entrySet()) {
            for (ResourceChange change : entry.getValue()) {
                Map projectChanges;
                Path resource = entry.getKey();
                Project project = this.projectService.resolveProject(resource);
                Package pkg = this.projectService.resolvePackage(resource);
                if (project == null || pkg == null) continue;
                if (!projectBatchChanges.containsKey(project)) {
                    projectBatchChanges.put(project, new HashMap());
                }
                if (!(projectChanges = (Map)projectBatchChanges.get(project)).containsKey(entry.getKey())) {
                    projectChanges.put(entry.getKey(), new ArrayList());
                }
                ((Collection)projectChanges.get(entry.getKey())).add(change);
                logger.info("- Batch content: " + entry.getKey().toURI() + " (" + change.getType().toString() + ").");
            }
        }
        for (final Map.Entry<Object, Collection<Object>> entry : projectBatchChanges.entrySet()) {
            this.getExecutor().execute(new AsyncIncrementalBuilder(){

                @Override
                public void execute(ProjectService projectService, BuildService buildService, Event<IncrementalBuildResults> incrementalBuildResultsEvent, Event<BuildResults> buildResultsEvent) {
                    try {
                        logger.info("Batch incremental build request being processed.");
                        Project project = (Project)entry.getKey();
                        Map changes = (Map)entry.getValue();
                        if (buildService.isBuilt(project)) {
                            IncrementalBuildResults results = buildService.applyBatchResourceChanges(project, changes);
                            incrementalBuildResultsEvent.fire((Object)results);
                        } else {
                            BuildResults results = buildService.build(project);
                            buildResultsEvent.fire((Object)results);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }

                @Override
                public String getDescription() {
                    return "Batch incremental build [" + ((Project)entry.getKey()).getProjectName() + "]";
                }
            });
        }
    }
}

