/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.common.services.project.client.GAVEditorView;
import org.guvnor.common.services.project.client.resources.ProjectResources;

public class GAVEditorViewImpl
extends Composite
implements GAVEditorView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    ControlGroup groupIdGroup;
    @UiField
    TextBox groupIdTextBox;
    @UiField
    HelpInline groupIdHelpInline;
    @UiField
    Icon gavHelpIcon;
    @UiField
    Icon gavHelpIcon2;
    @UiField
    Icon gavHelpIcon3;
    @UiField
    ControlGroup artifactIdGroup;
    @UiField
    TextBox artifactIdTextBox;
    @UiField
    HelpInline artifactIdHelpInline;
    @UiField
    ControlGroup versionGroup;
    @UiField
    TextBox versionTextBox;
    @UiField
    HelpInline versionHelpInline;
    private GAVEditorView.Presenter presenter;

    public GAVEditorViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.gavHelpIcon.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        this.gavHelpIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.gavHelpIcon2.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        this.gavHelpIcon2.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.gavHelpIcon3.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
        this.gavHelpIcon3.getElement().getStyle().setCursor(Style.Cursor.POINTER);
    }

    @Override
    public void setPresenter(GAVEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setGroupId(String id) {
        this.groupIdTextBox.setText(id);
    }

    @Override
    public void setArtifactId(String id) {
        this.artifactIdTextBox.setText(id);
    }

    @Override
    public void setVersion(String version) {
        this.versionTextBox.setText(version);
    }

    @Override
    public void disableGroupID(String reason) {
        this.groupIdTextBox.setEnabled(false);
        this.groupIdTextBox.setTitle(reason);
    }

    @Override
    public void disableArtifactID(String reason) {
        this.artifactIdTextBox.setEnabled(false);
        this.artifactIdTextBox.setTitle(reason);
    }

    @Override
    public void disableVersion(String reason) {
        this.versionTextBox.setEnabled(false);
        this.versionTextBox.setTitle(reason);
    }

    @Override
    public void setReadOnly() {
        this.groupIdTextBox.setReadOnly(true);
        this.artifactIdTextBox.setReadOnly(true);
        this.versionTextBox.setReadOnly(true);
    }

    @Override
    public void enableGroupID() {
        this.groupIdTextBox.setEnabled(true);
        this.groupIdTextBox.setTitle("");
    }

    @Override
    public void enableVersion() {
        this.versionTextBox.setEnabled(true);
        this.versionTextBox.setTitle("");
    }

    @Override
    public void setValidGroupID(boolean isValid) {
        if (isValid) {
            this.groupIdGroup.setType(ControlGroupType.NONE);
            this.groupIdHelpInline.setText("");
        } else {
            this.groupIdGroup.setType(ControlGroupType.ERROR);
            this.groupIdHelpInline.setText(ProjectResources.CONSTANTS.invalidGroupId());
        }
    }

    @Override
    public void setValidArtifactID(boolean isValid) {
        if (isValid) {
            this.artifactIdGroup.setType(ControlGroupType.NONE);
            this.artifactIdHelpInline.setText("");
        } else {
            this.artifactIdGroup.setType(ControlGroupType.ERROR);
            this.artifactIdHelpInline.setText(ProjectResources.CONSTANTS.invalidArtifactId());
        }
    }

    @Override
    public void setValidVersion(boolean isValid) {
        if (isValid) {
            this.versionGroup.setType(ControlGroupType.NONE);
            this.versionHelpInline.setText("");
        } else {
            this.versionGroup.setType(ControlGroupType.ERROR);
            this.versionHelpInline.setText(ProjectResources.CONSTANTS.invalidVersion());
        }
    }

    @UiHandler(value={"groupIdTextBox"})
    public void onGroupIdChange(KeyUpEvent event) {
        this.presenter.onGroupIdChange(this.groupIdTextBox.getText());
    }

    @UiHandler(value={"artifactIdTextBox"})
    public void onArtifactIdChange(KeyUpEvent event) {
        this.presenter.onArtifactIdChange(this.artifactIdTextBox.getText());
    }

    @UiHandler(value={"versionTextBox"})
    public void onVersionChange(KeyUpEvent event) {
        this.presenter.onVersionChange(this.versionTextBox.getText());
    }

    static interface Binder
    extends UiBinder<Widget, GAVEditorViewImpl> {
    }
}

