/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import org.guvnor.common.services.project.client.POMEditorPanel;
import org.guvnor.common.services.project.client.POMEditorPanelView;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;

public class POMEditorPanelTest {
    private POMEditorPanelView view;
    private POMEditorPanel panel;
    private PlaceManager placeManager;
    private POMEditorPanelView.Presenter presenter;

    @Before
    public void setUp() throws Exception {
        this.view = (POMEditorPanelView)Mockito.mock(POMEditorPanelView.class);
        this.placeManager = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.panel = new POMEditorPanel(this.view, this.placeManager);
        this.presenter = this.panel;
    }

    @Test
    public void testLoad() throws Exception {
        POM gavModel = this.createTestModel("group", "artifact", "1.1.1");
        gavModel.setParent(new GAV("org.parent", "parent", "1.1.1"));
        this.panel.setPOM(gavModel, false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setGAV(gavModel.getGav());
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setTitleText("artifact");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setParentGAV(gavModel.getParent());
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).disableGroupID("");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).disableVersion("");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).showParentGAV();
        gavModel = this.createTestModel("pomName", "pomDescription", "group", "artifact", "1.1.1");
        this.panel.setPOM(gavModel, false);
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setName("pomName");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).setDescription("pomDescription");
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableGroupID();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).enableVersion();
        ((POMEditorPanelView)Mockito.verify((Object)this.view)).hideParentGAV();
    }

    @Test
    public void testOpenProjectContext() throws Exception {
        this.presenter.onOpenProjectContext();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("repositoryStructureScreen");
    }

    private POM createTestModel(String group, String artifact, String version) {
        return new POM(new GAV(group, artifact, version));
    }

    private POM createTestModel(String name, String description, String group, String artifact, String version) {
        return new POM(name, description, new GAV(group, artifact, version));
    }
}

