/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.github.gwtbootstrap.client.ui.Fieldset;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.ArtifactIdChangeHandler;
import org.guvnor.common.services.project.client.GAVEditor;
import org.guvnor.common.services.project.client.GroupIdChangeHandler;
import org.guvnor.common.services.project.client.POMEditorPanelView;
import org.guvnor.common.services.project.client.VersionChangeHandler;
import org.guvnor.common.services.project.client.resources.ProjectResources;
import org.guvnor.common.services.project.model.GAV;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.workbench.events.NotificationEvent;

public class POMEditorPanelViewImpl
extends Composite
implements POMEditorPanelView {
    private String tabTitleLabel = ProjectResources.CONSTANTS.ProjectModel();
    private static GroupArtifactVersionEditorPanelViewImplBinder uiBinder = (GroupArtifactVersionEditorPanelViewImplBinder)GWT.create(GroupArtifactVersionEditorPanelViewImplBinder.class);
    private Event<NotificationEvent> notificationEvent;
    @UiField
    TextBox pomNameTextBox;
    @UiField
    TextArea pomDescriptionTextArea;
    @UiField(provided=true)
    GAVEditor gavEditor;
    @UiField(provided=true)
    GAVEditor parentGavEditor;
    @UiField
    Fieldset parentGavEditorFieldSet;
    private POMEditorPanelView.Presenter presenter;

    public POMEditorPanelViewImpl() {
    }

    @Inject
    public POMEditorPanelViewImpl(Event<NotificationEvent> notificationEvent, GAVEditor parentGavEditor, GAVEditor gavEditor) {
        this.parentGavEditor = parentGavEditor;
        this.gavEditor = gavEditor;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.notificationEvent = notificationEvent;
    }

    @Override
    public void setPresenter(POMEditorPanelView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showSaveSuccessful(String fileName) {
        this.notificationEvent.fire((Object)new NotificationEvent(ProjectResources.CONSTANTS.SaveSuccessful(fileName)));
    }

    @Override
    public String getTitleWidget() {
        return this.tabTitleLabel;
    }

    @Override
    public void setName(String projectName) {
        this.pomNameTextBox.setText(projectName);
    }

    @Override
    public void setDescription(String projectDescription) {
        this.pomDescriptionTextArea.setText(projectDescription);
    }

    @Override
    public void showParentGAV() {
        this.parentGavEditorFieldSet.setVisible(true);
    }

    @Override
    public void hideParentGAV() {
        this.parentGavEditorFieldSet.setVisible(false);
    }

    @Override
    public void setParentGAV(GAV gav) {
        this.parentGavEditor.setGAV(gav);
    }

    @Override
    public void setGAV(GAV gav) {
        this.gavEditor.setGAV(gav);
    }

    @Override
    public void addGroupIdChangeHandler(GroupIdChangeHandler changeHandler) {
        this.gavEditor.addGroupIdChangeHandler(changeHandler);
    }

    @Override
    public void addArtifactIdChangeHandler(ArtifactIdChangeHandler changeHandler) {
        this.gavEditor.addArtifactIdChangeHandler(changeHandler);
    }

    @Override
    public void addVersionChangeHandler(VersionChangeHandler changeHandler) {
        this.gavEditor.addVersionChangeHandler(changeHandler);
    }

    @Override
    public void setReadOnly() {
        this.gavEditor.setReadOnly();
    }

    @Override
    public void disableGroupID(String reason) {
        this.gavEditor.disableGroupID(reason);
    }

    @Override
    public void disableVersion(String reason) {
        this.gavEditor.disableVersion(reason);
    }

    @Override
    public void enableGroupID() {
        this.gavEditor.enableGroupID();
    }

    @Override
    public void enableVersion() {
        this.gavEditor.enableVersion();
    }

    @Override
    public void setTitleText(String titleText) {
        this.tabTitleLabel = titleText;
    }

    @Override
    public void setProjectModelTitleText() {
        this.tabTitleLabel = ProjectResources.CONSTANTS.ProjectModel();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public void setValidGroupID(boolean isValid) {
        this.gavEditor.setValidGroupID(isValid);
    }

    @Override
    public void setValidArtifactID(boolean isValid) {
        this.gavEditor.setValidArtifactID(isValid);
    }

    @Override
    public void setValidVersion(boolean isValid) {
        this.gavEditor.setValidVersion(isValid);
    }

    @UiHandler(value={"pomNameTextBox"})
    public void onNameChange(KeyUpEvent event) {
        this.presenter.onNameChange(this.pomNameTextBox.getText());
    }

    @UiHandler(value={"openProjectContext"})
    public void onOpenProjectContext(ClickEvent event) {
        this.presenter.onOpenProjectContext();
    }

    @UiHandler(value={"pomDescriptionTextArea"})
    public void onDescriptionChange(ValueChangeEvent<String> event) {
        this.presenter.onDescriptionChange(this.pomDescriptionTextArea.getText());
    }

    static interface GroupArtifactVersionEditorPanelViewImplBinder
    extends UiBinder<Widget, POMEditorPanelViewImpl> {
    }
}

