/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.client;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.ArtifactIdChangeHandler;
import org.guvnor.common.services.project.client.GroupIdChangeHandler;
import org.guvnor.common.services.project.client.NameChangeHandler;
import org.guvnor.common.services.project.client.POMEditorPanelView;
import org.guvnor.common.services.project.client.VersionChangeHandler;
import org.guvnor.common.services.project.model.POM;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PlaceManager;

@Dependent
public class POMEditorPanel
implements POMEditorPanelView.Presenter,
IsWidget {
    private ArrayList<NameChangeHandler> nameChangeHandlers = new ArrayList();
    private POMEditorPanelView view;
    private SyncBeanManager iocManager;
    private POM model;

    public POMEditorPanel() {
    }

    @Inject
    public POMEditorPanel(POMEditorPanelView view, SyncBeanManager iocManager) {
        this.view = view;
        this.iocManager = iocManager;
        view.setPresenter(this);
    }

    public void setPOM(POM model, boolean isReadOnly) {
        if (isReadOnly) {
            this.view.setReadOnly();
        }
        this.model = model;
        this.view.setName(model.getName());
        this.view.setDescription(model.getDescription());
        if (model.hasParent()) {
            this.view.setParentGAV(model.getParent());
            this.view.showParentGAV();
            this.view.disableGroupID("");
            this.view.enableArtifactID();
            this.view.disableVersion("");
        } else {
            this.view.hideParentGAV();
            this.view.enableGroupID();
            this.view.enableArtifactID();
            this.view.enableVersion();
        }
        this.view.setGAV(model.getGav());
        this.view.addArtifactIdChangeHandler(new ArtifactIdChangeHandler(){

            @Override
            public void onChange(String newArtifactId) {
                POMEditorPanel.this.setTitle(newArtifactId);
            }
        });
        this.setTitle(model.getGav().getArtifactId());
    }

    public void setArtifactID(String artifactID) {
        this.view.setArtifactID(artifactID);
    }

    private void setTitle(String titleText) {
        if (titleText == null || titleText.isEmpty()) {
            this.view.setProjectModelTitleText();
        } else {
            this.view.setTitleText(titleText);
        }
    }

    @Override
    public void addNameChangeHandler(NameChangeHandler changeHandler) {
        this.nameChangeHandlers.add(changeHandler);
    }

    @Override
    public void addGroupIdChangeHandler(GroupIdChangeHandler changeHandler) {
        this.view.addGroupIdChangeHandler(changeHandler);
    }

    @Override
    public void addArtifactIdChangeHandler(ArtifactIdChangeHandler changeHandler) {
        this.view.addArtifactIdChangeHandler(changeHandler);
    }

    @Override
    public void addVersionChangeHandler(VersionChangeHandler changeHandler) {
        this.view.addVersionChangeHandler(changeHandler);
    }

    @Override
    public void onNameChange(String name) {
        this.model.setName(name);
        for (NameChangeHandler changeHandler : this.nameChangeHandlers) {
            changeHandler.onChange(name);
        }
    }

    @Override
    public void onDescriptionChange(String description) {
        this.model.setDescription(description);
    }

    @Override
    public void onOpenProjectContext() {
        IOCBeanDef placeManagerIOCBeanDef = this.iocManager.lookupBean(PlaceManager.class, new Annotation[0]);
        ((PlaceManager)placeManagerIOCBeanDef.getInstance()).goTo("repositoryStructureScreen");
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void disableGroupID(String reason) {
        this.view.disableGroupID(reason);
    }

    @Override
    public void disableVersion(String reason) {
        this.view.disableVersion(reason);
    }

    @Override
    public POM getPom() {
        return this.model;
    }

    @Override
    public void setValidName(boolean isValid) {
        this.view.setValidName(isValid);
    }

    @Override
    public void setValidGroupID(boolean isValid) {
        this.view.setValidGroupID(isValid);
    }

    @Override
    public void setValidArtifactID(boolean isValid) {
        this.view.setValidArtifactID(isValid);
    }

    @Override
    public void setValidVersion(boolean isValid) {
        this.view.setValidVersion(isValid);
    }
}

